% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_c_dcore_sd.R
\name{lsm_c_dcore_sd}
\alias{lsm_c_dcore_sd}
\alias{lsm_c_dcore_sd.RasterLayer}
\alias{lsm_c_dcore_sd.RasterStack}
\alias{lsm_c_dcore_sd.RasterBrick}
\alias{lsm_c_dcore_sd.list}
\title{DCORE_SD (class level)}
\usage{
lsm_c_dcore_sd(landscape, directions)

\method{lsm_c_dcore_sd}{RasterLayer}(landscape, directions = 8)

\method{lsm_c_dcore_sd}{RasterStack}(landscape, directions = 8)

\method{lsm_c_dcore_sd}{RasterBrick}(landscape, directions = 8)

\method{lsm_c_dcore_sd}{list}(landscape, directions = 8)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick or a list of rasterLayers.}

\item{directions}{The number of directions in which patches should be connected: 4 (rook's case) or 8 (queen's case).}
}
\value{
tibble
}
\description{
Standard deviation number of disjunct core areas (Core area metric)
}
\details{
\deqn{DCORE_{SD} = sd(NCORE[patch_{ij}])}
where \eqn{NCORE[patch_{ij}]} is the number of core areas.

DCORE_SD is an 'Core area metric'. It summarises each class as the standard deviation
of all patch areas belonging to class i. A cell is defined as core if the cell
has no neighbour with a different value than itself (rook's case). NCORE counts the disjunct
core areas, whereby a core area is a 'patch within the patch' containing only core cells.
The metric describes the differences among patches of the same class i in
the landscape.

\subsection{Units}{None}
\subsection{Range}{DCORE_SD >= 0}
\subsection{Behaviour}{Equals DCORE_SD = 0 if all patches have the same number of disjunct
core areas. Increases, without limit, as the variation of number of disjunct core areas
increases.}
}
\examples{
lsm_c_dcore_sd(landscape)

}
\references{
McGarigal, K., SA Cushman, and E Ene. 2012. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical and Continuous Maps. Computer software program produced by
the authors at the University of Massachusetts, Amherst. Available at the following
web site: http://www.umass.edu/landeco/research/fragstats/fragstats.html
}
\seealso{
\code{\link{lsm_p_ncore}},
\code{\link{sd}}, \cr
\code{\link{lsm_c_dcore_mn}},
\code{\link{lsm_c_dcore_cv}}, \cr
\code{\link{lsm_l_dcore_mn}},
\code{\link{lsm_l_dcore_sd}},
\code{\link{lsm_l_dcore_cv}}
}
