% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ktd_cv2d.R
\name{ktd_cv2d}
\alias{ktd_cv2d}
\title{Cross validation for jointly tuning the regularization coefficient and kernel parameter in the Kernel Tweedie Model}
\usage{
ktd_cv2d(
  x,
  y,
  kernfunc,
  lambda,
  sigma,
  ncoefs,
  nfolds = 5,
  rho = 1.5,
  loss = "LL",
  ...
)
}
\arguments{
\item{x}{Covariate matrix.}

\item{y}{Outcome vector (e.g. insurance cost).}

\item{kernfunc}{Choice of kernel function. See \code{\link{dots}} for details on supported kernel functions.}

\item{lambda}{A vector of length two indicating the lower and upper bound from which candidate regularization coefficient values are sampled uniformly on the log scale.}

\item{sigma}{A vector of length two indicating the lower and upper bound from which candidate kernel parameter values are sampled uniformly on the log scale.}

\item{ncoefs}{The number of candidate \code{lambda} and \code{sigma} pairs to be evaluated.}

\item{nfolds}{Number of folds in cross-validation. Default is 5.}

\item{rho}{The power parameter of the Tweedie model. Default is 1.5 and can take any real value between 1 and 2.}

\item{loss}{Criterion used in cross-validation. "LL" for log likelihood, "RMSE" for root mean squared error, "MAD" for mean absolute difference. Default is "LL".}

\item{...}{Optional arguments to be passed to \code{ktd_estimate()}.}
}
\value{
A list of three items.
\enumerate{
\item LL or RMSE or MAD: a vector of validation error based on the user-specified \code{loss}, named by the corresponding \code{lambda} and \code{sigma} values;
\item Best_lambda: the \code{lambda} value in the pair that generates the best loss;
\item Best_sigma: the \code{sigma} value in the pair that generates the best loss.
}
}
\description{
\code{ktd_cv2d()} performs 2-dimensional random search from user-specified ranges to determine the optimal pair of regularization coefficient and kernel parameter of the \code{ktweedie} model.
}
\details{
\code{ktd_cv2d()} is a built-in wrapper for 2D random search for the regularization coefficient and kernel parameter. For kernel functions with greater than one parameters, \code{ktd_cv2d()} supports the tuning of the first one.
}
\examples{
### Cross-validation
# Provide the kernel function name (e.g. rbfdot) to the argument kernfunc,
# NOT the kernel function object, e.g. rbfdot(sigma = 1).
# Provide ranges where the candidate lambdas and sigmas are drawn from
# to the arguments lambda and sigma.
# The number of pairs of candidates to select from is specified by ncoefs.
( cv2d <- ktd_cv2d(x = dat$x, y = dat$y,
                   kernfunc = rbfdot,
                   lambda = c(1e-3, 1e0),
                   sigma = c(1e-3, 1e0),
                   ncoefs = 10) )
### Followed by fitting
fit <- ktd_estimate(x = dat$x, y = dat$y,
                    kern = rbfdot(sigma = cv2d$Best_sigma),
                    lam1 = cv2d$Best_lambda)
}
\seealso{
\code{\link{ktd_cv}}, \code{\link{ktd_estimate}}, \code{\link{ktd_predict}}
}
