% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getKSJData.R, R/translateKSJData.R
\name{getKSJData}
\alias{getKSJData}
\alias{translateKSJData}
\title{Get JPGIS2.1 Data}
\usage{
getKSJData(zip_file, cache_dir = tempdir(), encoding = "CP932")

translateKSJData(x, quiet = TRUE)
}
\arguments{
\item{zip_file}{Either a URL, a path to a zip file, or a path to a directory which contains shape files.}

\item{cache_dir}{Path to a directory for caching zip files.}

\item{encoding}{Encoding of the data.}

\item{x}{Object of class \link[sf]{sf}}

\item{quiet}{If \code{TRUE}, suppress messages.}
}
\description{
\code{getKSJData} tries to download and load spatial data from Kokudo Suuchi service. Note that this function
does not use API; directly download ZIP file and load the data by \link[sf]{read_sf}.
\code{translateKSJColnames} translates the column names of data (e.g. W05_001) into human readable ones.
By default, this is automatically done in \code{getKSJData}.
}
\examples{
\dontrun{
l <- getKSJData("http://nlftp.mlit.go.jp/ksj/gml/data/W07/W07-09/W07-09_3641-jgd_GML.zip")
names(l)
str(l, max.level = 1)

l_translated <- translateKSJData(l)
names(l)
}

}
\seealso{
\url{http://nlftp.mlit.go.jp/ksj/api/about_api.html}
}
