% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{unlock_gpg_key_passphrase}
\alias{unlock_gpg_key_passphrase}
\title{Functions that attempts to unlock a gpg key for decryption}
\usage{
unlock_gpg_key_passphrase(
  id = ifelse(is.null(name), ifelse(is.null(email), NULL,
    gpg::gpg_list_keys()$id[gpg::gpg_list_keys()$email == email]),
    gpg::gpg_list_keys()$id[gpg::gpg_list_keys()$name == name]),
  name = NULL,
  email = NULL
)
}
\arguments{
\item{id}{Identifier of the GPG key}

\item{name}{Name associated with the desired GPG key}

\item{email}{Email associated with the desired GPG key}
}
\value{
Will return the identifier of the GPG key that was unlocked.
}
\description{
This function will attempt to unlock a specific GPG key by first encrypting a
small amount of information using the (public) key and then immediately
decrypting it using the (private) key, thereby causing the keyring to
temporarily store the key passphrase. This can be helpful if one is trying
to knit a document with encrypted data chunks, but the key for those
data chunks is locked with a passphrase. See the package vignette section
\code{Workarounds for GPG data chunk error: Password callback did not return a string value}
for more details.
}
\seealso{
See also \code{\link{data_encode}}, \code{\link[gpg]{gpg_encrypt}}.
}
\author{
David M. Kaplan \email{dmkaplan2000@gmail.com}
}
