## ---- echo = FALSE-------------------------------------------------------
library(knitLatex)
knitr::opts_chunk$set(collapse = TRUE)
cars  <- mtcars[1:10,1:5]

## ------------------------------------------------------------------------
sTab(cars)

## ------------------------------------------------------------------------
sTab(cars, label = 'tab:mytable')

## ------------------------------------------------------------------------
sTab(cars, caption.top = 'my table')

## ------------------------------------------------------------------------
sTab(cars, caption.bottom = 'my table')

## ------------------------------------------------------------------------
sTab(cars, booktabs = TRUE)

## ------------------------------------------------------------------------
sTab(cars, booktabs = TRUE, midrule = '\\hline')

## ------------------------------------------------------------------------
sTab(cars,
     head = 'col1 & col 2 & col3 & \\eta & col5 \\\\')

## ------------------------------------------------------------------------
sTab(cars, head = NULL)

## ------------------------------------------------------------------------
sTab(cars, head = '', midrule = NULL)

## ------------------------------------------------------------------------
sTab(cars,
     firsthead = 'f1 & f2 & f3 & f4 & f5 \\\\')

## ------------------------------------------------------------------------
sTab(cars, toprule = NULL, midrule = NULL,
     firsthead = '\\toprule\nf1 & f2 & f3 & f4 & f5 \\\\\nmidrule',
     head = '\\hline\n col1 & col2 & col3 & cll4 & col5 \\\\\n\\hline')

## ------------------------------------------------------------------------
sTab(cars, toprule = NULL, midrule = NULL,
     firsthead = '\\toprule\nf1 & f2 & f3 & f4 & f5 \\\\\nmidrule',
     head = '\\toprule')

## ------------------------------------------------------------------------
sTab(cars, rows = TRUE)

## ------------------------------------------------------------------------
sTab(cars,
     rows =  TRUE,
     head = 'rows & col1 & col2 & col3 & \\eta & col5 \\\\')

## ------------------------------------------------------------------------
sTab(cars, rowsep = '\\hline')

## ------------------------------------------------------------------------
sTab(cars, rowsep = '\\midrule')

## ------------------------------------------------------------------------
sTab(cars, coldef ='rlc|l|p{5cm}')

## ------------------------------------------------------------------------
sTab(cars, colsep = '|')

