% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KinPairSimulation.R
\name{KinPairSimulation}
\alias{KinPairSimulation}
\title{KinPairSimulation Class}
\usage{
KinPairSimulation(
  data = NULL,
  kinship = NULL,
  lifestage = NULL,
  simtype = NULL,
  kerneltype = NULL,
  posigma = NULL,
  initsigma = NULL,
  breedsigma = NULL,
  gravsigma = NULL,
  ovisigma = NULL,
  simdims = NULL,
  kernelshape = NULL,
  call = NULL,
  filtertype = NULL,
  upper = NULL,
  lower = NULL,
  spacing = NULL,
  samplenum = NULL,
  sampledims = NULL
)

KinPairSimulation(
  data = NULL,
  kinship = NULL,
  lifestage = NULL,
  simtype = NULL,
  kerneltype = NULL,
  posigma = NULL,
  initsigma = NULL,
  breedsigma = NULL,
  gravsigma = NULL,
  ovisigma = NULL,
  simdims = NULL,
  kernelshape = NULL,
  call = NULL,
  filtertype = NULL,
  upper = NULL,
  lower = NULL,
  spacing = NULL,
  samplenum = NULL,
  sampledims = NULL
)
}
\arguments{
\item{data}{tbl_df. tibble  of simulation values}

\item{kinship}{character - one of PO, FS, HS, AV, HAV, GG, 1C, H1C, GAV, HGAV, 1C1, H1C1, GGG, 2C, and H2C.}

\item{lifestage}{character - one of 'unknown', 'immature' or 'ovipositional'}

\item{simtype}{character - simulation type}

\item{kerneltype}{character. - 'Gaussian', 'Laplace' or 'vgamma' (variance-gamma)}

\item{posigma}{numeric - overall value of dispersal sigma (for simple kernel)}

\item{initsigma}{numeric.    - value of pre-breeding dispersal sigma (for composite kernel)}

\item{breedsigma}{numeric.    - value of breeding dispersal sigma (for composite kernel)}

\item{gravsigma}{numeric.    - value of post-breeding dispersal sigma (for composite kernel)}

\item{ovisigma}{numeric.    - value of oviposition dispersal sigma (for composite kernel)}

\item{simdims}{numeric. - dimensions of sampling area (assumes one side of square)}

\item{kernelshape}{numeric. - value of kernel shape of simulation (if using kernel with shape parameter e.g. vgamma)}

\item{call}{call. Call to create object}

\item{filtertype}{character. whether the initial sim has been further filtered}

\item{upper}{numeric.       - FILTER: upper threshold used}

\item{lower}{numeric.       - FILTER: lower threshold used}

\item{spacing}{numeric.       - FILTER: spacing used}

\item{samplenum}{numeric.       - FILTER: sample number used}

\item{sampledims}{numeric.       - FILTER: sample dimensions used}
}
\value{
returns object of class \code{KinPairSimulation}

returns an object of class \code{KinPairSimulation}.
}
\description{
KinPairSimulation Class
}
\section{Slots}{

\describe{
\item{\code{kinship}}{character - one of PO, FS, HS, AV, HAV, GG, 1C, H1C, GAV, HGAV, 1C1, H1C1, GGG, 2C, and H2C.}

\item{\code{simtype}}{character.}

\item{\code{kerneltype}}{character. - 'Gaussian', 'Laplace' or 'vgamma' (variance-gamma)}

\item{\code{posigma}}{numeric.       - overall value of dispersal sigma (for simple kernel)}

\item{\code{initsigma}}{numeric.    - value of pre-breeding dispersal sigma (for composite kernel)}

\item{\code{breedsigma}}{numeric.  - value of breeding dispersal sigma (for composite kernel)}

\item{\code{gravsigma}}{numeric.   - value of post-breeding dispersal sigma (for composite kernel)}

\item{\code{ovisigma}}{numeric.    - value of oviposition dispersal sigma (for composite kernel)}

\item{\code{simdims}}{numeric.        - dimensions of sampling area (assumes 1 side of square)}

\item{\code{lifestage}}{character. - lifestage at sampling - either 'immature' or 'ovipositional'}

\item{\code{kernelshape}}{numeric.   - shape parameter if vgamma kerneltype}

\item{\code{call}}{call.           - call to create initial simulation}

\item{\code{tab}}{tbl_df.          - tibble of simulation values}

\item{\code{filtertype}}{character. - whether the initial sim has been further filtered}

\item{\code{upper}}{numeric.       - FILTER: upper threshold used}

\item{\code{lower}}{numeric.       - FILTER: lower threshold used}

\item{\code{spacing}}{numeric.     - FILTER: spacing used}

\item{\code{samplenum}}{numeric.   - FILTER: sample number used}

\item{\code{sampledims}}{numeric.  - FILTER: dimensions used}
}}

\examples{
KinPairSimulation()
}
