% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/palettes.R
\name{palette_color_continuous}
\alias{palette_color_continuous}
\alias{palette_colour_continuous}
\title{Color Mapping (continuous)}
\usage{
palette_color_continuous(
  colors = NULL,
  domain = NULL,
  midpoint = NULL,
  missing = "#DDDDDD"
)

palette_colour_continuous(
  colors = NULL,
  domain = NULL,
  midpoint = NULL,
  missing = "#DDDDDD"
)
}
\arguments{
\item{colors}{A vector of colors that values will be mapped to. If \code{NULL}
(the default), uses \emph{YlOrRd} (see \code{\link[grDevices:palettes]{grDevices::hcl.colors()}}).}

\item{domain}{A \code{\link{numeric}} range specifying the possible values that can be
mapped.}

\item{midpoint}{A length-one \code{\link{numeric}} vector specifying the mid-point of
input range.}

\item{missing}{The color to return for \code{NA} values.}
}
\value{
A palette \code{\link{function}} that when called with a single argument
(a \code{\link{numeric}} vector of continuous values) returns a \code{\link{character}} vector
of colors.
}
\description{
Maps continuous values to an interpolated colors gradient.
}
\examples{
## Visualize a simple DEM model
## Distribution of elevation values
elevation <- hist(volcano)

## Where are breaks?
elevation$breaks

## Build palette functions
BuRd <- color("BuRd")
ramp_BuRd <- palette_color_continuous(colors = BuRd(10))

## Plot image
image(volcano, col = ramp_BuRd(elevation$breaks))
legend("topright", legend = elevation$breaks, fill = ramp_BuRd(elevation$breaks))
}
\seealso{
Other palettes: 
\code{\link{palette_color_discrete}()},
\code{\link{palette_color_picker}()},
\code{\link{palette_shape}()},
\code{\link{palette_size_range}()}
}
\concept{palettes}
