% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot2.R
\name{scale_colour_tol}
\alias{scale_colour_tol}
\alias{scale_color_tol}
\alias{scale_fill_tol}
\title{Paul Tol's Colour Schemes for ggplot2}
\usage{
scale_colour_tol(..., palette, reverse = FALSE, aesthetics = "colour")

scale_color_tol(..., palette, reverse = FALSE, aesthetics = "colour")

scale_fill_tol(..., palette, reverse = FALSE, aesthetics = "fill")
}
\arguments{
\item{...}{Arguments passed to \code{\link[ggplot2]{discrete_scale}}
or \code{\link[ggplot2]{continuous_scale}}, used respectively for
qualitative data and diverging/sequential data.}

\item{palette}{A \code{\link{character}} string giving the name of
the palette to be used (see details).}

\item{reverse}{A \code{\link{logical}} scalar specifying if the resulting
vector of colours should be reversed.}

\item{aesthetics}{A \code{\link{character}} string or vector of character
strings listing the name(s) of the aesthetic(s) that this scale works with.}
}
\description{
Provides qualitative, diverging and sequential colour scales from Paul Tol's
 \emph{Colour Schemes}.
}
\details{
\strong{These methods are deprecated, use \code{\link{scale_tol_discrete}},
 \code{\link{scale_tol_diverging}} or \code{\link{scale_tol_sequential}}
 instead.}

 Paul Tol provides colour schemes ready for each type of data, with colours
 that are :
 \itemize{
  \item distinct for all people, including colour-blind readers;
  \item distinct from black and white;
  \item distinct on screen and paper;
  \item matching well together.
 }
 The qualitative colour schemes are used as given: colours are picked at
 random up to the maximum number of supported values (in brackets). Diverging
 and sequential colour schemes are linearly interpolated.
 The following palettes are available:
 \describe{
  \item{Qualitative data}{bright (7), vibrant (7), muted (9), light (9), rainbow (23)}
  \item{Diverging data}{sunset (11), BuRd (9), PRGn (9)}
  \item{Sequential data}{YlOrBr (9), smooth rainbow (34)}
 }
}
\examples{
\dontrun{
  library(ggplot2)

  # Qualitative data
  ggplot(mpg, aes(displ, hwy, colour = class)) +
    geom_point() +
    khroma::scale_colour_tol(palette = "bright")

  ggplot(diamonds, aes(clarity, fill = cut)) +
    geom_bar() +
    khroma::scale_fill_tol(palette = "vibrant")

  # Diverging data
  ggplot(economics, aes(psavert, pce, colour = unemploy)) +
    geom_point() +
    khroma::scale_color_tol(palette = "sunset")

  # Sequential data
  ggplot(faithfuld, aes(waiting, eruptions, fill = density)) +
    geom_raster() +
    khroma::scale_fill_tol(palette = "YlOrBr", reverse = TRUE)
}
}
\references{
Tol, Paul (2018). \emph{Colour Schemes.} SRON. Technical Note No.
 SRON/EPS/TN/09-002. URL: \url{https://personal.sron.nl/~pault/data/colourschemes.pdf}
}
\author{
N. Frerebeau
}
\concept{colour scales for ggplot2}
