% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/losses.R
\name{loss_ctc}
\alias{loss_ctc}
\title{CTC (Connectionist Temporal Classification) loss.}
\usage{
loss_ctc(
  y_true,
  y_pred,
  ...,
  reduction = "sum_over_batch_size",
  name = "sparse_categorical_crossentropy"
)
}
\arguments{
\item{y_true}{A tensor of shape \verb{(batch_size, target_max_length)} containing
the true labels in integer format. \code{0} always represents
the blank/mask index and should not be used for classes.}

\item{y_pred}{A tensor of shape \verb{(batch_size, output_max_length, num_classes)}
containing logits (the output of your model).
They should \emph{not} be normalized via softmax.}

\item{...}{For forward/backward compatability.}

\item{reduction}{Type of reduction to apply to the loss. In almost all cases
this should be \code{"sum_over_batch_size"}.
Supported options are \code{"sum"}, \code{"sum_over_batch_size"} or \code{NULL}.}

\item{name}{String, name for the object}
}
\value{
CTC loss value.
}
\description{
CTC (Connectionist Temporal Classification) loss.
}
