% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backend.R
\name{k_conv3d_transpose}
\alias{k_conv3d_transpose}
\title{3D deconvolution (i.e. transposed convolution).}
\usage{
k_conv3d_transpose(
  x,
  kernel,
  output_shape,
  strides = c(1, 1, 1),
  padding = "valid",
  data_format = NULL
)
}
\arguments{
\item{x}{input tensor.}

\item{kernel}{kernel tensor.}

\item{output_shape}{1D int tensor for the output shape.}

\item{strides}{strides}

\item{padding}{string, "same" or "valid".}

\item{data_format}{string, \code{"channels_last"} or \code{"channels_first"}. Whether
to use Theano or TensorFlow/CNTK data format for inputs/kernels/outputs.}
}
\value{
A tensor, result of transposed 3D convolution.
}
\description{
3D deconvolution (i.e. transposed convolution).
}
\section{Keras Backend}{


This function is part of a set of Keras backend functions that enable
lower level access to the core operations of the backend tensor engine
(e.g. TensorFlow, CNTK, Theano, etc.).

You can see a list of all available backend functions here:
\url{https://keras.rstudio.com/articles/backend.html#backend-functions}.
}

