% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activations.R
\name{activation_relu}
\alias{activation_relu}
\alias{activation_elu}
\alias{activation_selu}
\alias{activation_hard_sigmoid}
\alias{activation_linear}
\alias{activation_sigmoid}
\alias{activation_softmax}
\alias{activation_softplus}
\alias{activation_softsign}
\alias{activation_tanh}
\title{Activation functions}
\usage{
activation_relu(x, alpha = 0, max_value = NULL)

activation_elu(x, alpha = 1)

activation_selu(x)

activation_hard_sigmoid(x)

activation_linear(x)

activation_sigmoid(x)

activation_softmax(x, axis = -1)

activation_softplus(x)

activation_softsign(x)

activation_tanh(x)
}
\arguments{
\item{x}{Tensor}

\item{alpha}{Alpha value}

\item{max_value}{Max value}

\item{axis}{Integer, axis along which the softmax normalization is applied}
}
\value{
Tensor with the same shape and dtype as \code{x}.
}
\description{
Activations functions can either be used through \code{\link[=layer_activation]{layer_activation()}}, or
through the activation argument supported by all forward layers.
}
\details{
\itemize{
\item \code{activation_selu()} to be used together with the initialization "lecun_normal".
\item \code{activation_selu()} to be used together with the dropout variant "AlphaDropout".
}
}
\section{References}{

\itemize{
\item \code{activation_selu()}: \href{https://arxiv.org/abs/1706.02515}{Self-Normalizing Neural Networks}
}
}

