% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/learning_rate_schedules.R
\name{learning_rate_schedule_cosine_decay_restarts}
\alias{learning_rate_schedule_cosine_decay_restarts}
\title{A LearningRateSchedule that uses a cosine decay schedule with restarts}
\usage{
learning_rate_schedule_cosine_decay_restarts(
  initial_learning_rate,
  first_decay_steps,
  t_mul = 2,
  m_mul = 1,
  alpha = 0,
  ...,
  name = NULL
)
}
\arguments{
\item{initial_learning_rate}{A scalar \code{float32} or \code{float64} Tensor or an R
number. The initial learning rate.}

\item{first_decay_steps}{A scalar \code{int32} or \code{int64} \code{Tensor} or an R
number. Number of steps to decay over.}

\item{t_mul}{A scalar \code{float32} or \code{float64} \code{Tensor} or an R number. Used
to derive the number of iterations in the i-th period.}

\item{m_mul}{A scalar \code{float32} or \code{float64} \code{Tensor} or an R number. Used
to derive the initial learning rate of the i-th period.}

\item{alpha}{A scalar \code{float32} or \code{float64} Tensor or an R number. Minimum
learning rate value as a fraction of the initial_learning_rate.}

\item{...}{For backwards and forwards compatibility}

\item{name}{String. Optional name of the operation.  Defaults to
'SGDRDecay'.}
}
\description{
A LearningRateSchedule that uses a cosine decay schedule with restarts
}
\details{
See \href{https://arxiv.org/abs/1608.03983}{Loshchilov & Hutter, ICLR2016},
SGDR: Stochastic Gradient Descent with Warm Restarts.

When training a model, it is often useful to lower the learning rate as
the training progresses. This schedule applies a cosine decay function with
restarts to an optimizer step, given a provided initial learning rate.
It requires a \code{step} value to compute the decayed learning rate. You can
just pass a TensorFlow variable that you increment at each training step.

The schedule is a 1-arg callable that produces a decayed learning
rate when passed the current optimizer step. This can be useful for changing
the learning rate value across different invocations of optimizer functions.

The learning rate multiplier first decays
from 1 to \code{alpha} for \code{first_decay_steps} steps. Then, a warm
restart is performed. Each new warm restart runs for \code{t_mul} times more
steps and with \code{m_mul} times initial learning rate as the new learning rate.

You can pass this schedule directly into a keras Optimizer
as the \code{learning_rate}.
}
\seealso{
\itemize{
\item \url{https://www.tensorflow.org/api_docs/python/tf/keras/optimizers/schedules/CosineDecayRestarts}
}
}
