% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{evaluate_generator}
\alias{evaluate_generator}
\title{Evaluates the model on a data generator.}
\usage{
evaluate_generator(object, generator, steps, max_queue_size = 10)
}
\arguments{
\item{object}{Model object to evaluate}

\item{generator}{Generator yielding lists (inputs, targets) or (inputs,
targets, sample_weights)}

\item{steps}{Total number of steps (batches of samples) to yield from
\code{generator} before stopping.}

\item{max_queue_size}{maximum size for the generator queue}
}
\value{
Scalar test loss (if the model has a single output and no metrics) or
list of scalars (if the model has multiple outputs and/or metrics). The
attribute \code{model$metrics_names} will give you the display labels for the
scalar outputs.
}
\description{
The generator should return the same kind of data as accepted by
\code{test_on_batch()}.
}
\seealso{
Other model functions: \code{\link{compile}},
  \code{\link{evaluate}}, \code{\link{fit_generator}},
  \code{\link{fit}}, \code{\link{get_config}},
  \code{\link{get_layer}},
  \code{\link{keras_model_sequential}},
  \code{\link{keras_model}}, \code{\link{pop_layer}},
  \code{\link{predict.keras.engine.training.Model}},
  \code{\link{predict_generator}},
  \code{\link{predict_on_batch}},
  \code{\link{predict_proba}},
  \code{\link{summary.keras.engine.training.Model}},
  \code{\link{train_on_batch}}
}
