% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_kaya.R
\name{plot_kaya}
\alias{plot_kaya}
\title{Plot Kaya-identity variable}
\usage{
plot_kaya(
  kaya_data,
  variable,
  start_year = NA,
  stop_year = NA,
  y_lab = NULL,
  log_scale = FALSE,
  trend_line = FALSE,
  points = TRUE,
  font_size = 20,
  colors = NULL,
  pre_color = NULL,
  post_color = NULL,
  in_range_color = NULL,
  trend_color = NULL
)
}
\arguments{
\item{kaya_data}{A tibble with Kaya-identity data}

\item{variable}{The name of the variable to plot (character)}

\item{start_year}{The year to start highlighting the data (should correspond
to the beginning of the trend calculation). Set to \code{NULL} to turn off
highlighting.}

\item{stop_year}{The year to stop highlighting the data (should correspond
to the beginning of the trend calculation). Set to \code{NULL} to turn off
highlighting.}

\item{y_lab}{Optional label for the y-axis}

\item{log_scale}{Use log scale for y axis}

\item{trend_line}{Include a trend line}

\item{points}{Plot points in addition to the line.}

\item{font_size}{Base size of the font for axis labels and titles.}

\item{colors}{Named vector of colors to use for the plot. Elements should include
\code{PRE}, \code{POST}, \code{IN-RANGE}, and \code{TREND}, which respectively give the colors for
the portion of the plot before \code{start_year}, after \code{stop_year}, between
\code{start_year} and \code{stop_year}, and the trend line.}

\item{pre_color}{Override default color for the portion of the chart before
\code{start_year}.}

\item{post_color}{Override default color for the portion of the chart after
\code{stop_year}.}

\item{in_range_color}{Override default color for the portion of the chart
between \code{start_year} and \code{stop_year}.}

\item{trend_color}{Override default color for the trend line.}
}
\value{
A plot object.
}
\description{
Plot Kaya-identity variable
}
\examples{
china <- get_kaya_data("China")
plot_kaya(china, "F", 2001, 2011)
uk <- get_kaya_data("United Kingdom")
plot_kaya(uk, "e", log_scale = TRUE, trend_line = TRUE)
plot_kaya(uk, "e", log_scale = TRUE, trend_line = TRUE,
          start_year = 1970, stop_year = 2000,
          colors = c(PRE="limegreen", POST="darkgreen",
                     "IN-RANGE" = "cadetblue", TREMD="orange"))
plot_kaya(uk, "e", log_scale = TRUE, trend_line = TRUE,
          start_year = 1970, stop_year = 2000,
          pre_color = "limegreen", post_color = "limegreen",
          trend_color = "magenta")
world <- get_kaya_data("World")
plot_kaya(world, "g", 1982, log_scale = TRUE, trend_line = TRUE)
}
