% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kanji2.R
\name{kanjidistmat}
\alias{kanjidistmat}
\title{Compute distance matrix based on hierarchical optimal transport for lists of kanjivec objects}
\usage{
kanjidistmat(
  klist,
  klist2 = NULL,
  compo_seg_depth = 3,
  p = 1,
  C = 0.2,
  type = c("rtt", "unbalanced", "balanced"),
  size = 48,
  lwd = 2.5,
  verbose = FALSE
)
}
\arguments{
\item{klist}{a list of \code{\link{kanjimat}} objects.}

\item{klist2}{an optional second list of \code{\link{kanjimat}} objects.}

\item{compo_seg_depth}{integer \eqn{\geq 1}. Specifies for all kanji the
deepest level included for component matching. If 1, only the kanji itself is used.}

\item{p, C, type, size, lwd, verbose}{the same as for the function \code{\link{kanjidist}}.}
}
\value{
A matrix of dimension \code{length(klist)} x \code{length(klist2)} having
as its \eqn{(i,j)}-th entry the distance between \code{klist[[i]]} and
\code{klist2[[j]]}. If \code{klist2} is not provided it is assumed to be equal to
\code{klist}, but computation is more efficient as only the upper triangular part
is computed and then symmetrized with diagonal zero.
}
\description{
Individual distances are based on \code{\link{kanjidist}}.
}
\section{Warning}{


\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}\cr
The same precautions apply as for \code{\link{kanjidist}}.
}

\examples{
\donttest{
kanjidistmat(fivebetas)
}
}
\seealso{
\code{\link{kanjidist}}, \code{\link{kmatdistmat}}
}
