% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathway.r
\docType{methods}
\name{set_names,matrix-method}
\alias{set_names,matrix-method}
\title{Helper function to translate gene numbers to names}
\usage{
\S4method{set_names}{matrix}(x, nodes, my_list)
}
\arguments{
\item{x}{A \code{matrix} representing the network matrix.}

\item{nodes}{A \code{vector} of gene numbers to be replaced by names.}

\item{my_list}{A \code{data.frame} listing gene names and numbers. Output from 
\code{gene_name_number}.}
}
\value{
A \code{matrix} representing the interaction network in the pathway
with gene names as rownames and columnnames.
}
\description{
This function exchanges the numbers used for genes in KEGG download KGML files
with the corresponding gene names. Names are set to be the column names and 
rownames of the pathway's network matrix. The function 
is called by \code{get_network_matrix}. (For internal use)
}
\author{
Stefanie Friedrichs
}
\keyword{internal}
