% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{AoristicSum-class}
\alias{AoristicSum-class}
\alias{.AoristicSum}
\title{Aoristic Sum}
\description{
An S4 class to represent an aoristic analysis results.
}
\section{Slots}{

\describe{
\item{\code{breaks}}{An \code{\link[aion:RataDie-class]{aion::RataDie}} vector giving the date break between
time-blocks.}

\item{\code{weights}}{A \code{\link{numeric}} vector.}

\item{\code{groups}}{A \code{\link{character}} vector to store the group names (if any).}

\item{\code{p}}{A \code{\link{numeric}} \code{\link{array}} giving the aorisitic probabilities.}
}}

\note{
This class inherits from \code{\link[aion:TimeSeries-class]{aion::TimeSeries}}: dates are internally
stored as \emph{\link[aion:RataDie-class]{rata die}}.
}
\section{Coerce}{

In the code snippets below, \code{x} is an \code{AoristicSum} object.
\describe{
\item{\code{as.data.frame(x)}}{Coerces to a \code{\link{data.frame}}.}
}
}

\seealso{
Other classes: 
\code{\link{CountApportion-class}},
\code{\link{EventDate-class}},
\code{\link{IncrementTest-class}},
\code{\link{MeanDate-class}},
\code{\link{PermutationOrder-class}},
\code{\link{RateOfChange-class}},
\code{\link{RefinePermutationOrder-class}}
}
\author{
N. Frerebeau
}
\concept{classes}
\keyword{internal}
