% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plot.R
\docType{methods}
\name{plot_fit}
\alias{plot_fit}
\alias{autoplot,IncrementTest-method}
\alias{plot,IncrementTest,missing-method}
\title{Detection of Selective Processes}
\usage{
\S4method{autoplot}{IncrementTest}(object, ..., level = 0.95, roll = FALSE, window = 3)

\S4method{plot}{IncrementTest,missing}(x, level = 0.95, roll = FALSE, window = 3, ...)
}
\arguments{
\item{object, x}{An object to be plotted.}

\item{...}{Currently not used.}

\item{level}{A length-one \code{\link{numeric}} vector giving the confidence level.}

\item{roll}{A \code{\link{logical}} scalar: should each time series be subsetted to
look for episodes of selection?}

\item{window}{An odd \code{\link{integer}} giving the size of the rolling
window. Only used if \code{roll} is \code{TRUE}.}
}
\value{
\itemize{
\item \code{autoplot()} returns a \code{\link[ggplot2:ggplot]{ggplot}} object.
\item \code{plot()} is called it for its side-effects: it results in a graphic being
displayed (invisibly returns \code{x}).
}
}
\description{
Produces an abundance \emph{vs} time diagram.
}
\details{
Results of the frequency increment test can be displayed on an abundance
\emph{vs} time diagram aid in the detection and quantification of selective
processes in the archaeological record. If \code{roll} is \code{TRUE}, each time
series is subsetted according to \code{window} to see if episodes of selection
can be identified among decoration types that might not show overall
selection. If so, shading highlights the data points where
\code{\link[=fit]{fit()}} identifies selection.
}
\note{
Displaying FIT results on an abundance \emph{vs} time diagram is adapted from Ben
Marwick's \href{https://github.com/benmarwick/signatselect/}{original idea}.
}
\examples{
data("merzbach", package = "folio")

## Keep only decoration types that have a maximum frequency of at least 50
keep <- apply(X = merzbach, MARGIN = 2, FUN = function(x) max(x) >= 50)
counts <- merzbach[, keep]

## Group by phase
## We use the row names as time coordinates (roman numerals)
dates <- as.numeric(utils::as.roman(rownames(counts)))

## Frequency Increment Test
freq <- fit(counts, dates)

## Plot time vs abundance and highlight selection
plot(freq)
plot(freq, roll = TRUE, window = 5)
}
\seealso{
\code{\link[=fit]{fit()}}

Other plotting methods: 
\code{\link{plot_aoristic}},
\code{\link{plot_event}},
\code{\link{plot_mcd}},
\code{\link{plot_time}()}
}
\author{
N. Frerebeau
}
\concept{plotting methods}
