% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/aoristic.R
\docType{methods}
\name{plot_aoristic}
\alias{plot_aoristic}
\alias{autoplot,AoristicSum-method}
\alias{plot,AoristicSum,missing-method}
\alias{autoplot,RateOfChange-method}
\alias{plot,RateOfChange,missing-method}
\title{Plot Aoristic Analysis}
\usage{
\S4method{autoplot}{AoristicSum}(object, ..., facet = TRUE)

\S4method{plot}{AoristicSum,missing}(x, facet = TRUE, ...)

\S4method{autoplot}{RateOfChange}(object, ..., facet = TRUE)

\S4method{plot}{RateOfChange,missing}(x, facet = TRUE, ...)
}
\arguments{
\item{object, x}{An \linkS4class{AoristicSum} object.}

\item{...}{Currently not used.}

\item{facet}{A \code{\link{logical}} scalar: should a matrix of panels defined by
groups be drawn?}
}
\value{
\itemize{
\item \code{autoplot()} returns a \code{\link[ggplot2:ggplot]{ggplot}} object.
\item \code{plot()} is called it for its side-effects: it results in a graphic being
displayed (invisibly returns \code{x}).
}
}
\description{
Plot Aoristic Analysis
}
\examples{
## Aoristic Analysis
data("zuni", package = "folio")

## Set the start and end dates for each ceramic type
dates <- list(
  LINO = c(600, 875), KIAT = c(850, 950), RED = c(900, 1050),
  GALL = c(1025, 1125), ESC = c(1050, 1150), PUBW = c(1050, 1150),
  RES = c(1000, 1200), TULA = c(1175, 1300), PINE = c(1275, 1350),
  PUBR = c(1000, 1200), WING = c(1100, 1200), WIPO = c(1125, 1225),
  SJ = c(1200, 1300), LSJ = c(1250, 1300), SPR = c(1250, 1300),
  PINER = c(1275, 1325), HESH = c(1275, 1450), KWAK = c(1275, 1450)
)

## Keep only assemblages that have a sample size of at least 10
keep <- apply(X = zuni, MARGIN = 1, FUN = function(x) sum(x) >= 10)

## Calculate date ranges for each assemblage
span <- apply(
  X = zuni[keep, ],
  FUN = function(x, dates) {
    z <- range(unlist(dates[x > 0]))
    names(z) <- c("from", "to")
    z
  },
  MARGIN = 1,
  dates = dates
)

## Coerce to data.frame
span <- as.data.frame(t(span))

## Calculate aoristic sum (normal)
aorist_raw <- aoristic(span, step = 50, weight = FALSE)
plot(aorist_raw)

## Calculate aoristic sum (weights)
aorist_weigth <- aoristic(span, step = 50, weight = TRUE)
plot(aorist_weigth)

## Calculate aoristic sum (weights) by group
groups <- rep(c("A", "B", "C"), times = c(50, 90, 139))
aorist_groups <- aoristic(span, step = 50, weight = TRUE, groups = groups)
plot(aorist_groups)

## Rate of change
roc_weigth <- roc(aorist_weigth, n = 30)
plot(roc_weigth)

## Rate of change by group
roc_groups <- roc(aorist_groups, n = 30)
plot(roc_groups, facet = FALSE)
}
\seealso{
\code{\link[=aoristic]{aoristic()}}, \code{\link[=roc]{roc()}}

Other plotting methods: 
\code{\link{plot_event}},
\code{\link{plot_fit}},
\code{\link{plot_mcd}},
\code{\link{plot_time}()}
}
\author{
N. Frerebeau
}
\concept{plotting methods}
