% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resp01_functions.R
\name{resp01_a_comp_stat_factor}
\alias{resp01_a_comp_stat_factor}
\title{Formatted Analysis Function for Comparative Statistic in Response Tables (RESP01)}
\usage{
resp01_a_comp_stat_factor(df, .var, include, ...)
}
\arguments{
\item{df}{(\code{data.frame})\cr data set containing all analysis variables.}

\item{.var}{(\code{string})\cr single variable name that is passed by \code{rtables} when requested
by a statistics function.}

\item{include}{(\code{character})\cr for which factor levels to include the comparison
statistic results.}

\item{\dots}{see \code{\link[=resp01_a_comp_stat_logical]{resp01_a_comp_stat_logical()}} for additional required arguments.}
}
\value{
The formatted result as \code{\link[rtables:rcell]{rtables::rcell()}}.
}
\description{
This function applies to a \code{factor} column called \code{.var} from \code{df}.
}
\examples{
dm <- droplevels(subset(formatters::DM, SEX \%in\% c("F", "M")))

resp01_a_comp_stat_factor(
  dm,
  .var = "COUNTRY",
  conf_level = 0.9,
  include = c("USA", "CHN"),
  arm = "SEX",
  strata = "RACE",
  stat = "comp_stat_ci",
  method = list(comp_stat_ci = "or_cmh"),
  formats = list(
    comp_stat_ci = jjcsformat_xx("xx.xx (xx.xx - xx.xx)"),
    pval = jjcsformat_pval_fct(0.05)
  )
)
}
