% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/re-import.R
\name{jst_re_import}
\alias{jst_re_import}
\title{Re-import files}
\usage{
jst_re_import(file, warn = TRUE)
}
\arguments{
\item{file}{A path to a .csv file.}

\item{warn}{Should warnings be emitted, if the type of file cannot be
determined?}
}
\description{
\code{jst_re_import()} lets you re-import a file which was exported via
\code{\link[=jst_import]{jst_import()}} or \code{\link[=jst_import_zip]{jst_import_zip()}}.
}
\details{
When attempting to re-import, a heuristic is applied. If the file has column
names which match the names from any of the \code{find_*} functions, the file
is read with the corresponding specifications. If no column names are
recognized, files are recognized based on the number of columns. Since both
references and footnotes have only two columns, the first line is inspected
for either \code{"Referenc...|Bilbio...|Endnote..."} or \code{"Footnote..."}.
In case there is still no match, the file is read with
\code{\link[readr:read_csv]{readr::read_csv()}} with \code{guess_max = 5000} and a warning is raised.
}
\seealso{
\code{\link[=jst_combine_outputs]{jst_combine_outputs()}}
}
