% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proptestn.h.R
\name{propTestN}
\alias{propTestN}
\title{Proportion Test (N Outcomes)}
\usage{
propTestN(data, var, counts = NULL, expected = FALSE, ratio = NULL)
}
\arguments{
\item{data}{the data as a data frame}

\item{var}{a string naming the variable of interest in \code{data}}

\item{counts}{a string naming a variable in \code{data} containing counts,
or NULL if each row represents a single observation}

\item{expected}{\code{TRUE} or \code{FALSE} (default), whether expected
counts should be displayed}

\item{ratio}{a vector of numbers: the expected proportions}
}
\value{
A results object containing:
\tabular{llllll}{
  \code{results$props} \tab \tab \tab \tab \tab a table of the proportions \cr
  \code{results$tests} \tab \tab \tab \tab \tab a table of the test results \cr
}

Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:

\code{results$props$asDF}

\code{as.data.frame(results$props)}
}
\description{
X² Goodness of fit
}
\examples{
data('HairEyeColor')
dat <- as.data.frame(HairEyeColor)

propTestN(dat, var = 'Eye', counts = 'Freq', ratio = c(1,1,1,1))

#
#  PROPORTION TEST (N OUTCOMES)
#
#  Proportions
#  --------------------------------
#    Level    Count    Proportion
#  --------------------------------
#    Brown      220         0.372
#    Blue       215         0.363
#    Hazel       93         0.157
#    Green       64         0.108
#  --------------------------------
#
#
#  X² Goodness of Fit
#  -----------------------
#    X²     df    p
#  -----------------------
#    133     3    < .001
#  -----------------------
#

}
