
# This file is automatically generated, you probably don't want to edit this

#' @importFrom jmvcore Options
#' @importFrom R6 R6Class
efaOptions <- R6::R6Class(
    "efaOptions",
    inherit = jmvcore::Options,
    public = list(
        initialize = function(
            vars = NULL,
            nFactorMethod = "parallel",
            nFactors = 1,
            minEigen = 1,
            rotation = "oblimin",
            hideLoadings = 0.3,
            screePlot = FALSE,
            eigenValues = FALSE,
            factorCor = FALSE,
            factorSummary = FALSE,
            modelFit = FALSE,
            kmoTest = FALSE,
            bartlettTest = FALSE, ...) {

            super$initialize(
                package='jmv',
                name='efa',
                requiresData=TRUE,
                ...)
        
            private$..vars <- jmvcore::OptionVariables$new(
                "vars",
                vars,
                suggested=list(
                    "ordinal",
                    "continuous"),
                permitted=list(
                    "continuous",
                    "nominal",
                    "ordinal"),
                rejectInf=FALSE)
            private$..nFactorMethod <- jmvcore::OptionList$new(
                "nFactorMethod",
                nFactorMethod,
                options=list(
                    "parallel",
                    "eigen",
                    "fixed"),
                default="parallel")
            private$..nFactors <- jmvcore::OptionInteger$new(
                "nFactors",
                nFactors,
                min=1,
                default=1)
            private$..minEigen <- jmvcore::OptionNumber$new(
                "minEigen",
                minEigen,
                default=1)
            private$..rotation <- jmvcore::OptionList$new(
                "rotation",
                rotation,
                options=list(
                    "none",
                    "varimax",
                    "quartimax",
                    "promax",
                    "oblimin",
                    "simplimax"),
                default="oblimin")
            private$..hideLoadings <- jmvcore::OptionNumber$new(
                "hideLoadings",
                hideLoadings,
                default=0.3)
            private$..screePlot <- jmvcore::OptionBool$new(
                "screePlot",
                screePlot,
                default=FALSE)
            private$..eigenValues <- jmvcore::OptionBool$new(
                "eigenValues",
                eigenValues,
                default=FALSE)
            private$..factorCor <- jmvcore::OptionBool$new(
                "factorCor",
                factorCor,
                default=FALSE)
            private$..factorSummary <- jmvcore::OptionBool$new(
                "factorSummary",
                factorSummary,
                default=FALSE)
            private$..modelFit <- jmvcore::OptionBool$new(
                "modelFit",
                modelFit,
                default=FALSE)
            private$..kmoTest <- jmvcore::OptionBool$new(
                "kmoTest",
                kmoTest,
                default=FALSE)
            private$..bartlettTest <- jmvcore::OptionBool$new(
                "bartlettTest",
                bartlettTest,
                default=FALSE)
        
            self$.addOption(private$..vars)
            self$.addOption(private$..nFactorMethod)
            self$.addOption(private$..nFactors)
            self$.addOption(private$..minEigen)
            self$.addOption(private$..rotation)
            self$.addOption(private$..hideLoadings)
            self$.addOption(private$..screePlot)
            self$.addOption(private$..eigenValues)
            self$.addOption(private$..factorCor)
            self$.addOption(private$..factorSummary)
            self$.addOption(private$..modelFit)
            self$.addOption(private$..kmoTest)
            self$.addOption(private$..bartlettTest)
        }),
    active = list(
        vars = function() private$..vars$value,
        nFactorMethod = function() private$..nFactorMethod$value,
        nFactors = function() private$..nFactors$value,
        minEigen = function() private$..minEigen$value,
        rotation = function() private$..rotation$value,
        hideLoadings = function() private$..hideLoadings$value,
        screePlot = function() private$..screePlot$value,
        eigenValues = function() private$..eigenValues$value,
        factorCor = function() private$..factorCor$value,
        factorSummary = function() private$..factorSummary$value,
        modelFit = function() private$..modelFit$value,
        kmoTest = function() private$..kmoTest$value,
        bartlettTest = function() private$..bartlettTest$value),
    private = list(
        ..vars = NA,
        ..nFactorMethod = NA,
        ..nFactors = NA,
        ..minEigen = NA,
        ..rotation = NA,
        ..hideLoadings = NA,
        ..screePlot = NA,
        ..eigenValues = NA,
        ..factorCor = NA,
        ..factorSummary = NA,
        ..modelFit = NA,
        ..kmoTest = NA,
        ..bartlettTest = NA)
)

#' @import jmvcore
#' @importFrom R6 R6Class
efaResults <- R6::R6Class(
    inherit = jmvcore::Group,
    active = list(
        text = function() private$..text),
    private = list(
        ..text = NA),
    public=list(
        initialize=function(options) {
            super$initialize(options=options, name="", title="Exploratory Factor Analysis")
            private$..text <- jmvcore::Preformatted$new(
                options=options,
                name="text",
                title="Exploratory Factor Analysis")
            self$add(private$..text)}))

#' @importFrom jmvcore Analysis
#' @importFrom R6 R6Class
efaBase <- R6::R6Class(
    "efaBase",
    inherit = jmvcore::Analysis,
    public = list(
        initialize = function(options, data=NULL, datasetId="", analysisId="", revision=0) {
            super$initialize(
                package = 'jmv',
                name = 'efa',
                version = c(1,0,0),
                options = options,
                results = efaResults$new(options=options),
                data = data,
                datasetId = datasetId,
                analysisId = analysisId,
                revision = revision,
                pause = NULL,
                completeWhenFilled = FALSE)
        }))

#' Exploratory Factor Analysis
#'
#' Exporatory Factor Analysis
#'
#' @examples
#' data('iris')
#' dat <- as.data.frame(iris)
#' 
#' jmv::efa(data = dat, vars = c('Sepal.Length', 'Sepal.Width', 'Petal.Length', 'Petal.Width'))
#' 
#' #
#' #  Factor Loadings
#' #  -------------------------------------------------
#' #                    1        2         Uniqueness
#' #  -------------------------------------------------
#' #    Sepal.Length    0.948                 0.10181
#' #    Sepal.Width              -0.747       0.42199
#' #    Petal.Length    0.917     0.394       0.00483
#' #    Petal.Width     0.883     0.388       0.07088
#' #  -------------------------------------------------
#' #    Note. 'varimax' rotation was used
#' #
#' #
#' 
#' @param data .
#' @param vars a vector of strings naming the variables of interest in 
#'   \code{data}
#' @param nFactorMethod \code{'parallel'} (default), \code{'eigen'} or 
#'   \code{'fixed'}, the way to determine the number of factors 
#' @param nFactors an integer (default: 1), the number of factors in the model 
#' @param minEigen a number (default: 1), the minimal eigenvalue for a factor 
#'   to be included in the model 
#' @param rotation \code{'none'}, \code{'varimax'} (default), 
#'   \code{'quartimax'}, \code{'promax'}, \code{'oblimin'}, or 
#'   \code{'simplimax'}, the rotation to use in estimation 
#' @param hideLoadings a number (default: 0.3), hide loadings below this value 
#' @param screePlot \code{TRUE} or \code{FALSE} (default), show scree plot 
#' @param eigenValues \code{TRUE} or \code{FALSE} (default), show eigenvalue 
#'   table 
#' @param factorCor \code{TRUE} or \code{FALSE} (default), show factor 
#'   correlations 
#' @param factorSummary \code{TRUE} or \code{FALSE} (default), show factor 
#'   summary 
#' @param modelFit \code{TRUE} or \code{FALSE} (default), show model fit 
#'   measures and test 
#' @param kmoTest \code{TRUE} or \code{FALSE} (default), show 
#'   Kaiser-Meyer-Olkin (KMO) measure of sampling adequacy (MSA) results 
#' @param bartlettTest \code{TRUE} or \code{FALSE} (default), show Bartlett's 
#'   test of sphericity results 
#' @export
efa <- function(
    data,
    vars,
    nFactorMethod = "parallel",
    nFactors = 1,
    minEigen = 1,
    rotation = "oblimin",
    hideLoadings = 0.3,
    screePlot = FALSE,
    eigenValues = FALSE,
    factorCor = FALSE,
    factorSummary = FALSE,
    modelFit = FALSE,
    kmoTest = FALSE,
    bartlettTest = FALSE) {

    options <- efaOptions$new(
        vars = vars,
        nFactorMethod = nFactorMethod,
        nFactors = nFactors,
        minEigen = minEigen,
        rotation = rotation,
        hideLoadings = hideLoadings,
        screePlot = screePlot,
        eigenValues = eigenValues,
        factorCor = factorCor,
        factorSummary = factorSummary,
        modelFit = modelFit,
        kmoTest = kmoTest,
        bartlettTest = bartlettTest)

    results <- efaResults$new(
        options = options)

    analysis <- efaClass$new(
        options = options,
        data = data)

    analysis$run()

    analysis$results
}
