% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jagshelper1.R
\name{pull_post}
\alias{pull_post}
\title{Subset from posterior data.frame}
\usage{
pull_post(x, p = NULL, exact = FALSE)
}
\arguments{
\item{x}{Posterior \code{data.frame}}

\item{p}{String to begin posterior names.  If \code{NULL} is used, all parameters will be returned.}

\item{exact}{Whether name must be an exact match (\code{TRUE}) or with initial sub-string matching only supplied characters (\code{FALSE}).  Defaults to \code{FALSE}.
Defaults to \code{FALSE.}}
}
\value{
A \code{data.frame} with a column associated with each (subsetted) parameter and a row
associated with each MCMC iteration.
}
\description{
Extracts a subset vector or \code{data.frame} from a \code{data.frame} consisting of more columns,
such that column names match a name given in the \verb{p=} argument.  This may be useful
in creating smaller objects consisting of MCMC samples.
}
\examples{
out_df <- jags_df(asdf_jags_out)

b <- pull_post(out_df, p="b")
str(b)
a <- pull_post(out_df, p=c("a","sig_a"))
str(a)
sigs <- pull_post(out_df, p="sig")
str(sigs)
justsig <- pull_post(out_df, p="sig", exact=TRUE)
str(justsig)
}
\seealso{
\link{jags_df}
}
\author{
Matt Tyers
}
