% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Schur.R
\name{SchurR}
\alias{SchurR}
\title{Evaluation of Schur polynomials}
\usage{
SchurR(x, lambda, algorithm = "DK")
}
\arguments{
\item{x}{numeric or complex vector or \link[gmp]{bigq} vector}

\item{lambda}{an integer partition, given as a vector of decreasing
integers}

\item{algorithm}{the algorithm used, either \code{"DK"} (Demmel-Koev)
or \code{"naive"}}
}
\value{
A numeric or complex scalar or a \code{bigq} rational number.
}
\description{
Evaluates a Schur polynomial.
}
\examples{
x <- c(2,3,4)
SchurR(x, c(2,1,1))
prod(x) * sum(x)
}
\references{
J. Demmel & P. Koev.
\emph{Accurate and efficient evaluation of Schur and Jack functions}.
Mathematics of computations, vol. 75, n. 253, 223-229, 2005.
}
\seealso{
\code{\link{SchurPolR}}
}
