% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/invFM.R
\name{invFM}
\alias{invFM}
\title{Fourier transform approach on inverse dimention reduction method.}
\usage{
invFM(x,y,d,w,x_scale = TRUE)
}
\arguments{
\item{x}{The design matrix of the predictor with dimension n-by-p.}

\item{y}{The n-dimensional response vector.}

\item{d}{An integer specifying the dimension of the sufficient dimension reduction subspace.}

\item{w}{A vector of choices for \emph{w}.}

\item{x_scale}{(default TRUE). It scales the predictor variables.}
}
\value{
\emph{invFM} returns the following objects
 
 \item{beta}{The estimated p by d matrix, whose columns forme a basis of the central subspace.}

 \item{eigenvalue}{Eigenvalues of \eqn{\widehat{\bold{V}}}.}
 
 \item{psi}{Estimation for \eqn{\widehat{\bold{\Psi}}}.}
}
\description{
\emph{invFM()} estimates the basis vector for the central subspace in regression.
}
\details{
Let \eqn{(\bold{y}_i,\bold{x}_i), i =1,\cdots,n}, be a random sample, and assume that the dimension of \eqn{S_{E(\bold{Z} | \bold{Y})}} is known to be \emph{d}.
Then, for a random finite sequence of \eqn{\bold{\omega}_j \in \mathcal{R}^p}, \eqn{j=1,\cdots,t} compute \eqn{\widehat{\bold{\psi}}(\bold{\omega}_j)} as follows. For more details see Weng and Yin (2018).  
\deqn{\widehat{\bold{\psi}}(\bold{\omega}_j)=n^{-1}\sum_{k=1}^n \exp\{i\bold{\omega}_j^T\bold{y}_k\}\widehat{\bold{Z}}_k, j=1,\cdots,t,}
where \eqn{\widehat{\bold{Z}}_j=\bold{\Sigma}_{x}^{-1/2}(\bold{x}_i-\overline{\bold{x}})}. Now, let
\eqn{\bold{a}(\bold{\omega}_j)=Real(\widehat{\bold{\psi}}(\bold{\omega}_j))}, and \eqn{\bold{b}(\bold{\omega}_j)=Image(\widehat{\bold{\psi}}(\bold{\omega}_j))}. Then, 
\eqn{\widehat{\bold{\Psi}}= (\bold{a}(\bold{\omega}_1),\bold{b}(\bold{\omega}_1),\cdots,\bold{a}(\bold{\omega}_t),\bold{b}(\bold{\omega}_t))}, for some \eqn{t > 0}, and the population kernel matrix is
\eqn{\widehat{\bold{V}} = \widehat{\bold{\Psi}}\widehat{\bold{\Psi}}^T}. Finally, use the \emph{d}-leading eigenvectors of \eqn{\widehat{\bold{V}}} as an estimate for the central subspace.

\bold{Remark: }We use \emph{w} instead of \eqn{\bold{\omega}_1,\cdots,\bold{\omega}_t} in the \emph{invFM()} function.
}
\examples{
library(itdr)
library(stats)
data(PDB)
colnames(PDB)=NULL
p=15
df=PDB[,c(79,73,77,103,112,115,124,130,132,145,149,151,153,155,167,169)]
dff=as.matrix(df)
planingdb=dff[complete.cases(dff),]
y=planingdb[,1]
x=planingdb[,c(2:(p+1))]
x=x+0.5
xt=cbind(x[,1]^(.33),x[,2]^(.33),x[,3]^(.57),x[,4]^(.33),
x[,5]^(.4),x[,6]^(.5),x[,7]^(.33),x[,8]^(.16),x[,9]^(.27),x[,10]^(.5),
x[,11]^(.5),x[,12]^(.33),x[,13]^(.06),x[,14]^(.15),x[,15]^(.1))
W=sapply(50,rnorm)
d=1
betahat <-invFM(xt,y,d,W,FALSE)$beta
betahat

}
\references{
Weng J. and Yin X. (2018). Fourier Transform Approach for Inverse Dimension Reduction Method. \emph{Journal of Nonparametric Statistics}. 30, 4, 1029-0311.
}
