% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui_priors.R
\name{sample_from_prior}
\alias{sample_from_prior}
\title{Sample from a prior object}
\usage{
sample_from_prior(x, n = 1)
}
\arguments{
\item{x}{A \code{prior} object.}

\item{n}{Integer, number of samples to draw.}
}
\value{
A numeric vector of length \code{n}.
}
\description{
Sample from a prior object
}
\examples{
sample_from_prior(constant(1))
sample_from_prior(constant(1), 10)
sample_from_prior(hcauchy(0.5), 1)
hist(sample_from_prior(hcauchy(0.5), 20))
hist(sample_from_prior(uniform(0, 3), 1000))
hist(sample_from_prior(scaled_beta(3, 7, 2), 1e4))

}
