% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/ternary_hull.R
\docType{methods}
\name{ternary_hull}
\alias{ternary_hull}
\alias{ternary_hull-method}
\alias{ternary_hull,numeric,numeric,numeric-method}
\alias{ternary_hull,ANY,missing,missing-method}
\title{Convex Hull of a Set of Points}
\usage{
ternary_hull(x, y, z, ...)

\S4method{ternary_hull}{numeric,numeric,numeric}(x, y, z, center = FALSE, scale = FALSE, ...)

\S4method{ternary_hull}{ANY,missing,missing}(x, center = FALSE, scale = FALSE, ...)
}
\arguments{
\item{x, y, z}{A \code{\link{numeric}} vector giving the x, y and z ternary coordinates
of a set of points. If \code{y} and \code{z} are missing, an attempt is made to
interpret \code{x} in a suitable way (see \code{\link[grDevices:xyz.coords]{grDevices::xyz.coords()}}).}

\item{...}{Further arguments to be passed to \code{\link[graphics:polygon]{graphics::polygon()}}.}

\item{center}{A \code{\link{logical}} scalar specifying wether the data should be
centered, or a \code{\link{numeric}} vector giving the center.}

\item{scale}{A \code{\link{logical}} scalar specifying wether the data should be
scaled, or a \code{\link{numeric}} vector giving the scale factor.}
}
\value{
\code{ternary_hull()} is called it for its side-effects.
}
\description{
Computes and draws the convex hull of the set of points specified.
}
\examples{
## Convex hull
## Data from Aitchison 1986
ternary_plot(lava, panel.first = ternary_grid(5, 10))
ternary_hull(lava, border = "red")
}
\seealso{
\code{\link[grDevices:chull]{grDevices::chull()}}, \code{\link[graphics:polygon]{graphics::polygon()}}

Other statistics: 
\code{\link{ternary_contour}()},
\code{\link{ternary_density}()},
\code{\link{ternary_ellipse}()},
\code{\link{ternary_mean}()},
\code{\link{ternary_pca}()}
}
\author{
N. Frerebeau
}
\concept{statistics}
