% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/ternary_grid.R
\docType{methods}
\name{ternary_grid}
\alias{ternary_grid}
\title{Add Grid to a Ternary Plot}
\usage{
ternary_grid(
  primary = NULL,
  secondary = NULL,
  col.primary = "darkgray",
  col.secondary = "lightgray",
  lty.primary = "dashed",
  lty.secondary = "dotted",
  lwd.primary = 1,
  lwd.secondary = lwd.primary
)
}
\arguments{
\item{primary}{An \code{\link{integer}} specifying the number of cells of the primary
grid in \code{x}, \code{y} and \code{z} direction.}

\item{secondary}{An \code{\link{integer}} specifying the number of cells of the
secondary grid in \code{x}, \code{y} and \code{z} direction.}

\item{col.primary, col.secondary}{A \code{\link{character}} string specifying the color
of the grid lines.}

\item{lty.primary, lty.secondary}{A \code{\link{character}} string or \code{\link{numeric}}
value specifying the line type of the grid lines.}

\item{lwd.primary, lwd.secondary}{A non-negative \code{\link{numeric}} value specifying
the line width of the grid lines.}
}
\value{
\code{ternary_grid()} is called it for its side-effects.
}
\description{
Adds a triangular grid to an existing plot.
}
\examples{
## Blank plot
ternary_plot(NULL)

## Compositional data
coda <- data.frame(
  X = c(20, 60, 20, 1/3),
  Y = c(20, 20, 60, 1/3),
  Z = c(60, 20, 20, 1/3)
)

## Ternary plot
ternary_plot(coda, pch = 16, col = "red")

## Add a grid
ternary_plot(coda, panel.first = ternary_grid(5, 10))

## Zoom
ternary_plot(coda, xlim = c(0.5, 1), panel.first = ternary_grid())
ternary_plot(coda, ylim = c(0.5, 1), panel.first = ternary_grid())
ternary_plot(coda, zlim = c(0.5, 1), panel.first = ternary_grid())

## Color according to a supplementary variable
## Data from Aitchison 1986
col <- grDevices::colorRampPalette(c("red", "blue"))(nrow(arctic))
ternary_plot(arctic, panel.first = ternary_grid(), pch = 16, col = col)
}
\seealso{
Other graphical elements: 
\code{\link{ternary_axis}()},
\code{\link{ternary_box}()},
\code{\link{ternary_pairs}()},
\code{\link{ternary_plot}()},
\code{\link{ternary_title}()}
}
\author{
N. Frerebeau
}
\concept{graphical elements}
