% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clumped.R
\name{D48}
\alias{D48}
\title{Equilibrium carbonate D47 value}
\usage{
D48(temp, eq)
}
\arguments{
\item{temp}{Carbonate growth temperature (°C).}

\item{eq}{Equation used for the calculation.
\itemize{
\item \code{"Fiebig21"}: the CDES90 calibration of Fiebig et al. (2021).
\item \code{"Swart21"}: the CDES90 "PBLM1" calibration in Swart et al. (2021).
}}
}
\value{
Returns the carbonate equilibrium D48 value
expressed on the CDES90 scale (‰).
}
\description{
\code{D48()} calculates the equilibrium carbonate D48 value
for a given temperature.
}
\details{
\strong{"Fiebig21"}:

\deqn{\Delta_{48, CDES90} = 1.028 \times (6.002 \times \frac{1}{T}
                  - 1.299 \times \frac{10^{4}}{T^{2}}
                  + 8.996 \times \frac{10^{6}}{T^{3}}
                  - 7.423 \times \frac{10^{8}}{T^{4}}) + 0.1245}

\strong{"Swart21"}:

\deqn{\Delta_{48, CDES90} =
0.0142 \times \frac{10^{6}}{T^{2}} + 0.088}
}
\examples{
D48(temp = 33.7, eq = "Fiebig21") # Returns 0.237
D48(temp = 33.7, eq = "Swart21") # Returns 0.239

}
\references{
Bajnai, D., Guo, W., Spötl, C., Coplen, T. B.,
Methner, K., Löffler, N., et al. (2020).
Dual clumped isotope thermometry resolves kinetic biases in
carbonate formation temperatures.
Nature Communications, 11, 4005.
\doi{10.1038/s41467-020-17501-0}

Fiebig, J., Daëron, M., Bernecker, M., Guo, W.,
Schneider, G., Boch, R., et al. (2021).
Calibration of the dual clumped isotope thermometer for carbonates.
Geochimica et Cosmochimica Acta.
\doi{10.1016/j.gca.2021.07.012}

Swart, P. K., Lu, C., Moore, E., Smith, M.,
Murray, S. T., & Staudigel, P. T. (2021).
A calibration equation between D48 values of carbonate and temperature.
Rapid Communications in Mass Spectrometry, 35(17), e9147.
\doi{10.1002/rcm.9147}
}
\seealso{
Other equilibrium_carbonate: 
\code{\link{D47}()},
\code{\link{d17O_c}()},
\code{\link{d18O_c}()}
}
\concept{equilibrium_carbonate}
