% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/irtmodel.R
\name{prm}
\alias{prm}
\title{Polytomous Response Model (PRM) Probabilities (GRM and GPCM)}
\usage{
prm(theta, a, d, D = 1, pr.model = c("GRM", "GPCM"))
}
\arguments{
\item{theta}{A vector of ability values.}

\item{a}{A numeric value of item discrimination (or slope) parameter.}

\item{d}{A vector of item difficulty (or threshold) parameters.}

\item{D}{A scaling factor in IRT models to make the logistic function as close as possible to the normal
ogive function  (if set to 1.7). Default is 1.}

\item{pr.model}{A character string indicating the polytomous model being used. Available models are "GRM" for
the the graded response model and "GPCM" for the (generalized) partial credit model.}
}
\value{
This function returns a matrix where a row indicates the ability and a column represents
score categories of the item.
}
\description{
This function computes the probability of selecting a specific category for an item
for a given set of theta values using the graded response model and (generalized) partial credit model.
}
\details{
When the category probabilities are computed for an item with the partial credit model, provide \code{a = 1} for that item.
When \code{model = "GPCM"}, \code{d} should include the item difficulty (or threshold) parameters. In the \pkg{irtQ} package,
the item difficulty (or threshold) parameters of category boundaries for GPCM are expressed as the item location (or overall difficulty)
parameter subtracted by the threshold parameter for unique score categories of the item. Note that when an GPCM item has \emph{K}
unique score categories, \emph{K-1} item difficulty parameters are necessary because the item difficulty parameter for the first category
boundary is always 0. For example, if an GPCM item has five score categories, four item difficulty parameters should be specified.
For more details about the parameterization of the (generalized) partial credit model, See \code{IRT Models} section
in the page of \code{\link{irtQ-package}}.
}
\examples{
## Category probabilities for an item with four categories
## using a generalized partial credit model
prm(theta = c(-0.2, 0, 0.5), a = 1.4, d = c(-0.2, 0, 0.5), D = 1, pr.model = "GPCM")

## Category probabilities for an item with five categories
## using a graded response model
prm(theta = c(-0.2, 0, 0.5), a = 1.2, d = c(-0.4, -0.2, 0.4, 1.5), D = 1, pr.model = "GRM")

}
\seealso{
\code{\link{drm}}, \code{\link{irtfit}}
}
\author{
Hwanggyu Lim \email{hglim83@gmail.com}
}
