% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_info.R
\name{plot.info}
\alias{plot.info}
\title{Plot Item and Test Information Functions}
\usage{
\method{plot}{info}(
  x,
  item.loc = NULL,
  overlap = FALSE,
  csee = FALSE,
  xlab.text,
  ylab.text,
  main.text,
  lab.size = 15,
  main.size = 15,
  axis.size = 15,
  line.color,
  line.size = 1,
  layout.col = 4,
  strip.size = 12,
  ...
)
}
\arguments{
\item{x}{x An object of class \code{\link{info}}.}

\item{item.loc}{A vector of numeric values indicating that the item information functions of the \emph{n}th items
(or the location of items in a test form) are plotted. If NULL, the test information function for the total test form is drawn.
Default is NULL.}

\item{overlap}{Logical value indicating whether multiple item information functions are plotted in one panel.
If FALSE, multiple item information functions are displayed in multiple panels, one for each.}

\item{csee}{Logical value indicating whether the function displays the conditional standard error of estimation (CSEE) at a test level.
If FALSE, item/test information function is plotted. Note that the CSEE plot is displayed only at a test level.}

\item{xlab.text, ylab.text}{A title for the x and y axes.}

\item{main.text}{An overall title for the plot.}

\item{lab.size}{The size of xlab and ylab. Default is 15.}

\item{main.size}{The size of \code{main.text}. Default is 15.}

\item{axis.size}{The size of labels along the x and y axes. Default is 15.}

\item{line.color}{A character string specifying a color for the line. See \url{http://www.cookbook-r.com/Graphs/Colors_(ggplot2)/}
for more details about colors used in ggplot2.}

\item{line.size}{The size of lines. Default is 1.}

\item{layout.col}{An integer value indicating the number of columns in the panel when displaying the item information functions of
the multiple items. Default is 4.}

\item{strip.size}{The size of facet labels when the item information functions of the multiple items are drawn.}

\item{...}{Further arguments passed from the function \code{geom_line()} in the \pkg{ggplot2} package.}
}
\value{
This method function displays the item or test information function plot. When \code{csee = TRUE},
the conditional standard error is returned at the test level.
}
\description{
This method function plots item or test information function given a specified theta values. In addition,
it displays the conditional standard errors at a test level.
}
\details{
All of the plots are drawn using the ggplot2 package.
The object of class \code{\link{info}} can be obtained from the function \code{\link{info}}.
}
\examples{
## the use of a "-prm.txt" file obtained from a flexMIRT
# import the "-prm.txt" output file from flexMIRT
flex_prm <- system.file("extdata", "flexmirt_sample-prm.txt", package = "irtQ")

# read item parameters and transform them to item metadata
test_flex <- bring.flexmirt(file=flex_prm, "par")$Group1$full_df

# set theta values
theta <- seq(-4, 4, 0.1)

# compute item and test information values given the theta values
x <- info(x=test_flex, theta=theta, D=1, tif=TRUE)

# draw a plot of the test information function
plot(x)

# draw a plot of the item information function for the second item
plot(x, item.loc=2)

# draw a plot of multiple item information functions across the multiple panels
plot(x, item.loc=1:8, overlap=FALSE)

# draw a plot of multiple item information functions in one panel
plot(x, item.loc=1:8, overlap=TRUE)

# draw a plot of conditional standard error at a test level
plot(x, csee=TRUE)

}
\seealso{
\code{\link{info}}
}
\author{
Hwanggyu Lim \email{hglim83@gmail.com}
}
