% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cat_sim_helper_functions.R
\name{calculate_overlap_rates}
\alias{calculate_overlap_rates}
\title{Calculate overlap rate of items for CAT}
\usage{
calculate_overlap_rates(cat_sim_output, cd = NULL, item_ids = NULL)
}
\arguments{
\item{cat_sim_output}{This is a list object containing elements that are
"cat_output" class.}

\item{cd}{A \code{cat_design} object that is created by function
\code{create_cat_design}.}

\item{item_ids}{A vector of item (or Testlet) ids in the item pool.}
}
\value{
This function returns a numeric vector of each item's overlap rate
  where the names of each overlap rate value is the item's ID.
}
\description{
This function calculates the overlap rate of items for a
CAT. It takes a list of \code{cat_output} objects and \code{cat_design}
object and returns exposure rate of each item.
}
\examples{
cd <- create_cat_design(ip = generate_ip(n = 30), next_item_rule = 'mfi',
                        termination_rule = 'max_item',
                        termination_par = list(max_item = 10))
cat_data <- cat_sim(true_ability = rnorm(10), cd = cd)
calculate_overlap_rates(cat_data, cd = cd)

}
\seealso{
\code{\link{cat_sim}}
}
\author{
Emre Gonulates
}
