% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ironseed.R
\name{ironseed}
\alias{ironseed}
\alias{create_seedseq}
\alias{is_ironseed}
\alias{is_ironseed_str}
\alias{as_ironseed}
\alias{parse_ironseed_str}
\title{Ironseed: Improved Random Number Generator Seeding}
\usage{
ironseed(..., set_seed = !has_random_seed(), quiet = FALSE)

create_seedseq(fe, n)

is_ironseed(x)

is_ironseed_str(x)

as_ironseed(x)

parse_ironseed_str(x)
}
\arguments{
\item{...}{objects}

\item{set_seed}{a logical indicating whether to initialize \code{.Random.seed}.}

\item{quiet}{a logical indicating whether to silence messages.}

\item{fe}{an ironseed}

\item{n}{a scalar integer specifying the number of seeds to generate}

\item{x}{a string, ironseed, or other object}
}
\value{
An ironseed. If \code{.Random.seed} was initialized, the ironseed used
will be returned invisibly.
}
\description{
An ironseed is a 256-bit hash digest constructed from a variable-length
input sequence and can be used to generate a variable-length output sequence
of seeds, including initializing R's built-in random number generator.
\itemize{
\item \code{ironseed()} creates an ironseed from user supplied objects or
automatically from multiple sources of entropy on the local system. It also
initializes R's built-in random number generator from an ironseed.
\item \code{create_seqseq()} uses an ironseed to generate a sequence of 32-bit seeds.
\item \code{is_ironseed()} tests whether an object is an ironseed, and
\code{is_ironseed_str()} tests if it is a string representing and ironseed.
\item \code{as_ironseed()} casts an object to an ironseed, and \code{parse_ironseed_str()}
parses a string to an ironseed.
}
}
\details{
Ironseeds have a specific string representation, e.g.
"rBQSjhjYv1d-z8dfMATEicf-sw1NSWAvVDi-bQaKSKKQmz1", where each element is a
64-bit number encoded in little-endian base58 format.

Parameter \code{set_seed} defaults to \code{TRUE} if \code{.Random.seed} does not already
exist and \code{FALSE} otherwise.

Ironseed behaves differently depending on the number of arguments passed as
\code{...}.
\itemize{
\item 0 arguments: If initialization is enabled, \code{ironseed()} generates an
automatic ironseed. Otherwise, \code{ironseed()} returns the last ironseed used
to initialize \code{.Random.seed}.
\item 1 argument: \code{ironseed(NULL)} generates an automatic ironseed. For
\code{ironseed(x)}, if \code{x} is an ironseed object, it is used as is. If \code{x}, is
a scalar character that matches an ironseed string, it is parsed to an
ironseed. Otherwise, \code{x} hashed to create an ironseed.
\item 2+ arguments: \code{ironseed(x,y,...)} hashes the arguments to create an
ironseed.
}

An ironseed is a finite-entropy (or fixed-entropy) hash digest that can be
used to generate an unlimited sequence of seeds for initializing the state of
a random number generator. It is inspired by the work of M.E. O’Neill and
others.

An ironseed is a 256-bit hash digest constructed from a variable-length
sequence of 32-bit inputs. Each ironseed consists of eight 32-bit
sub-digests. The sub-digests are 32-bit multilinear hashes that accumulate
entropy from the input sequence. Each input is included in every sub-digest.
The coefficients for the multilinear hashes are generated by a Weyl sequence.

Multilinear hashes are also used to generate an output seed sequence from an
ironseed. Each 32-bit output value is generated by uniquely hashing the
sub-digests. The coefficients for the output are generated by a second
Weyl sequence.
}
\examples{

\dontshow{
oldseed <- ironseed::get_random_seed()
}

# Generate an ironseed with user supplied data
ironseed::ironseed("Experiment", 20251031, 1)

# Generate an ironseed automatically and initialize `.Random.seed` with it
ironseed::ironseed(set_seed = TRUE)

\dontshow{
ironseed::set_random_seed(oldseed)
}

}
\references{
\itemize{
\item O’Neill (2015) Developing a seed_seq Alternative.
\url{https://www.pcg-random.org/posts/developing-a-seed_seq-alternative.html}
\item O’Neill (2015) Simple Portable C++ Seed Entropy.
\url{https://www.pcg-random.org/posts/simple-portable-cpp-seed-entropy.html}
\item O’Neill (2015) Random-Number Utilities.
\url{https://gist.github.com/imneme/540829265469e673d045}
\item Lemire and Kaser (2018) Strongly universal string hashing is fast.
\url{http://arxiv.org/pdf/1202.4961}
\item Weyl Sequence \url{https://en.wikipedia.org/wiki/Weyl_sequence}
}
}
\seealso{
\link{.Random.seed}
}
