% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampling_distance.R
\name{sampling_distance}
\alias{sampling_distance}
\title{Sampling distance Plot}
\usage{
sampling_distance(
  irace_results,
  type = c("boxplot", "line", "both"),
  t = 0.05,
  filename = NULL
)
}
\arguments{
\item{irace_results}{The data generated when loading the \code{.Rdata} file created by \code{irace} (or the filename of that file).}

\item{type}{String, (default "boxplot") Type of plot to be produces, either "line", "boxplot"
or "both". The "boxplot" setting shows a boxplot of the mean distance of all
configurations, "line" shows the mean distance of the solution population in each
iteration, "both" shows both plots.}

\item{t}{Numeric, (default 0.05) percentage factor that will determine a distance to
define equal numerical parameter values. If the numerical parameter values to be
compared are v1 and v2 they are considered equal if \verb{|v1-v2| <= |ub-lb|*t}.}

\item{filename}{(\code{character(1)}) File name to save the plot, for example \code{"~/path/example/filename.png"}.}
}
\value{
line or box plot
}
\description{
The \code{sampling_distance} function creates a plot that displays the mean of the
distance between the configurations that were executed in each iteration.

For categorical parameters the distance is calculated as the hamming distance,
for numerical parameters a equality interval is defined by a threshold
specified by argument t and hamming distance is calculated using this interval.
}
\examples{
iraceResults <- read_logfile(system.file(package="irace", "exdata",
                                         "irace-acotsp.Rdata", mustWork = TRUE))
sampling_distance(iraceResults)
\donttest{
sampling_distance(iraceResults, type = "boxplot", t=0.07)
}
}
