% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{get_ptm_ppi_from_file}
\alias{get_ptm_ppi_from_file}
\title{Get post translational modification (PTM) depentdent protein-protein interaction for kinases from file}
\usage{
get_ptm_ppi_from_file(file_name)
}
\arguments{
\item{file_name}{A string representing file name of the file containing the list of kinases.
The file should be a Tab seperated file with three columns "substrate_ac", "site_residue" and "position" without headers.
Example :
Q13619    S    10
Q8TDM6    S    1021
Q6ZRV2    S    1025
Q15121    S    104
O15164    S    1042
Q8NDI1    S    1058
P00533    S    1064
Q16555    S    107
Q8NFC6    S    1077}
}
\value{
A dataframe containing the PTM dependent PPI interaction information.
}
\description{
This function is similar to \link{get_ptm_ppi_from_list} except that it loads the kinases from TSV file
}
\examples{
\dontrun{ptm_dep_ppi = get_ptm_ppi_from_file(kinases.txt)}
}
