% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logLik.R
\name{logLik}
\alias{logLik}
\alias{logLik.ipriorMod}
\alias{logLik.ipriorKernel}
\alias{deviance}
\alias{deviance.ipriorMod}
\alias{deviance.ipriorKernel}
\title{Obtain the log-likelihood and deviance of an \code{ipriorMod} or
\code{ipriorKernel} object}
\usage{
\method{logLik}{ipriorMod}(object, theta = NULL, ...)

\method{logLik}{ipriorKernel}(object, theta = NULL, ...)

\method{deviance}{ipriorMod}(object, theta = NULL, ...)

\method{deviance}{ipriorKernel}(object, theta = NULL, ...)
}
\arguments{
\item{object}{An object of class \code{ipriorMod} or \code{ipriorKernel}.}

\item{theta}{(optional) Evaluates the log-likelihood at \code{theta} which is
of the form \code{theta = c(lambda, psi)}.}

\item{...}{No further arguments required, so this is not used for
\code{ipriorMod} or \code{ipriorKernel} class objects.}
}
\description{
This function calculates the log-likelihood value or deviance (twice the
negative log-likelihood) for I-prior models. It works for both
\code{ipriorMod} and \code{ipriorKernel} class objects.
}
\details{
For \code{ipriorKernel} objects, the log-likelihood or deviance is calculated
at \emph{random parameter values} by default. This is because it uses the
(random) initial values for the parameters from the EM algorithm. For
\code{ipriorMod} objects, the default value is the last obtained set of
parameter values of the EM algorithm. If the model has converged, then this
should be the maximum likelihood (ML) value.

For both types of object, it is possible to supply a parameter value at which
to calculate the log-likelihood/deviance. This makes estimating an I-prior
model more flexible, by first loading the variables into an
\code{ipriorKernel} object, and then using an optimiser such as
\code{\link[stats]{optim}}. Any other optimiser that can implement bounded
constraints can be used. The only constraint requirement is on the parameter
\code{psi} which has to be greater than zero (although setting the constraint
to a small number such as \code{1e-9} will avoid an ill conditioned
variance).

Direct maximisation of the log-likelihood of I-prior models can be unreliable
some times, but other times it could also lead to a better set of parameters
if the EM does not converge fully. Perhaps in the future, this package can
make use of both methods combined as standard.

As a side note, the ML estimate for the intercept of an I-prior model is the
mean of the responses \code{y}, and therefore not included as a parameter of
the log-likelihood/deviance function.
}
\examples{
mod.iprior <- iprior(stack.loss ~ ., data=stackloss)
logLik(mod.iprior)

# Using optim to find ML estimates
optim(abs(rnorm(4)), deviance, object = mod.iprior,
      method="L-BFGS-B", lower = c(-Inf, -Inf, -Inf, 1e-9))
coef(mod.iprior)
deviance(mod.iprior)

}
