% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ipdwInterp.R
\name{ipdwInterp}
\alias{ipdwInterp}
\title{Inverse Distance Weighting with custom distances}
\usage{
ipdwInterp(spdf, rstack, paramlist, overlapped = FALSE, yearmon = "default",
  removefile = TRUE)
}
\arguments{
\item{spdf}{SpatialPointsDataFrame object}

\item{rstack}{RasterStack of path distances}

\item{paramlist}{chacter. String representing parameter names}

\item{overlapped}{logical. Default is FALSE, specify TRUE if some points lie on top of barriers}

\item{yearmon}{character. String specifying the name of the spdf}

\item{removefile}{logical. Remove files after processing?}
}
\value{
RasterLayer
}
\description{
Inverse Distance Weighting with custom distances
}
\examples{
spdf<-data.frame(rnorm(2))
xy<-data.frame(x=c(4,2),y=c(8,4))
coordinates(spdf)<-xy
m<-matrix(NA,10,10)
costras<-raster(m,xmn=0,xmx=ncol(m),ymn=0,ymx=nrow(m))
#introduce spatial gradient
costras[]<-runif(ncell(costras),min=1,max=10)
for(i in 1:nrow(costras)){
costras[i,]<-costras[i,]+i
costras[,i]<-costras[,i]+i
}

rstack<-pathdistGen(spdf,costras,100)
final.raster<-ipdwInterp(spdf,rstack,paramlist=c("rnorm.2."))
plot(final.raster)
}
\author{
Joseph Stachelek
}

