% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/async-progress.R
\docType{data}
\name{AsyncProgress}
\alias{AsyncProgress}
\title{A progress bar object where inc and set are usable within other processes}
\arguments{
\item{session}{The Shiny session object, as provided by
\code{shinyServer} to the server function.}

\item{min}{The value that represents the starting point of the
progress bar. Must be less tham \code{max}.}

\item{max}{The value that represents the end of the progress bar.
Must be greater than \code{min}.}

\item{message}{A single-element character vector; the message to be
displayed to the user, or \code{NULL} to hide the current message
(if any).}

\item{detail}{A single-element character vector; the detail message
to be displayed to the user, or \code{NULL} to hide the current
detail message (if any). The detail message will be shown with a
de-emphasized appearance relative to \code{message}.}

\item{value}{A numeric value at which to set
the progress bar, relative to \code{min} and \code{max}.}

\item{queue}{A Queue object for message passing}

\item{millis}{How often in milliseconds should updates to the progress bar be checked for.}
}
\description{
An async compatible wrapper around Shiny's progress bar. It should be instatiated
from the main process, but may be closed, set and incremented from any process.
}
\details{
\strong{Methods}
  \describe{
    \item{\code{initialize(..., queue=shinyQueue(), millis=250, value=NULL, message=NULL, detail=NULL)}}{
      Creates a new progress panel and displays it.
    }
    \item{\code{set(value = NULL, message = NULL, detail = NULL)}}{
      Updates the progress panel. When called the first time, the
      progress panel is displayed.
    }
    \item{\code{inc(amount = 0.1, message = NULL, detail = NULL)}}{
      Like \code{set}, this updates the progress panel. The difference is
      that \code{inc} increases the progress bar by \code{amount}, instead
      of setting it to a specific value.
    }
    \item{\code{sequentialClose()}}{
      Removes the progress panel and destroys the queue. Must be called from main process.
    }
    \item{\code{close()}}{
      Fires a close signal and may be used from any process.
    }
  }
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {
library(shiny)
library(future)
plan(multiprocess)
ui <- fluidPage(
  actionButton("run","Run"),
  tableOutput("dataset")
)

server <- function(input, output, session) {

  dat <- reactiveVal()
  observeEvent(input$run, {
    progress <- AsyncProgress$new(session, min=1, max=15)
    future({
      for (i in 1:15) {
        progress$set(value = i)
        Sys.sleep(0.5)
      }
      progress$close()
      cars
    }) \%...>\% dat
    NULL
  })

  output$dataset <- renderTable({
    req(dat())
  })
}

shinyApp(ui, server)
}
}
\keyword{datasets}
