% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uid.r
\name{uid}
\alias{uid}
\alias{hash}
\title{Generate Names}
\usage{
uid()

hash(str)
}
\arguments{
\item{str}{A string (scalar character).}
}
\value{
A string (scalar character) that can be used as a mutex,
semaphore, or message queue name.
}
\description{
To ensure broad compatibility across different operating systems, names of
mutexes, semaphores, and message queues should start with a letter followed
by up to 249 alphanumeric characters. These functions generate names meeting
these requirements.\cr\cr
\itemize{
\item \code{uid()}: 12-character encoding of PID and time since epoch.
\item \code{hash()}: 12-character hash of any string (hash space = 2^64).
}
}
\details{
\code{uid()}s will not collide with a \code{hash()}.
\itemize{
\item \code{uid()}s never start with \code{'Z'}.
\item \code{hash()}s always start with \code{'Z'}.
}

\code{uid()}s will not collide with a \code{ps::ps_string()}.
\itemize{
\item \code{uid()}s are always 12 characters long.
\item \code{ps::ps_string()}s are always 11 characters long.
}

\code{uid()}s will not collide with each other.
\itemize{
\item The first 4 characters encode the current PID.
\item The last 8 characters encode sequential 1/10000 second intervals that the
current process was alive. Attempting to generate more than 10,000 UIDs per
second will cause the process to momentarily sleep.
}
}
\examples{

    library(interprocess)
    
    uid()
    
    hash('192.168.1.123:8011')
    
}
