% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot_gride.R
\name{autoplot.gride_bayes}
\alias{autoplot.gride_bayes}
\title{Plot the simulated MCMC chains for the Bayesian \code{Gride}}
\usage{
\method{autoplot}{gride_bayes}(
  object,
  traceplot = FALSE,
  title = "Bayesian Gride - Posterior distribution",
  ...
)
}
\arguments{
\item{object}{object of class \code{gride_bayes}.
It is obtained using the output of the \code{gride} function when
\code{method = "bayes"}.}

\item{traceplot}{logical. If \code{FALSE}, the function returns a plot of the
posterior density. If \code{TRUE}, the function returns the traceplots of the
MCMC used to simulate from the posterior distribution.}

\item{title}{optional string to display as title.}

\item{...}{other arguments passed to specific methods.}
}
\value{
object of class \code{\link[ggplot2]{ggplot}}.
It could represent the traceplot of the posterior simulations for the
Bayesian \code{Gride} model (\code{traceplot = TRUE}) or a density plot
of the simulated posterior distribution (\code{traceplot = FALSE}).
}
\description{
Use this method without the \code{.gride_bayes} suffix.
It displays the traceplot of the chain generated
with Metropolis-Hasting updates to visually assess mixing and convergence.
Alternatively, it is possible to plot the posterior density.
}
\seealso{
\code{\link{gride}}

Other autoplot methods: 
\code{\link{autoplot.Hidalgo}()},
\code{\link{autoplot.twonn_bayes}()},
\code{\link{autoplot.twonn_linfit}()},
\code{\link{autoplot.twonn_mle}()}
}
\concept{autoplot methods}
