% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rating_factors.R
\name{autoplot.riskfactor}
\alias{autoplot.riskfactor}
\title{Automatically create a ggplot for objects obtained from rating_factors()}
\usage{
\method{autoplot}{riskfactor}(
  object,
  risk_factors = NULL,
  ncol = 1,
  labels = TRUE,
  dec.mark = ",",
  ylab = "rate",
  fill = NULL,
  color = NULL,
  linetype = FALSE,
  ...
)
}
\arguments{
\item{object}{riskfactor object produced by \code{rating_factors()}}

\item{risk_factors}{character vector to define which factors are included.
Defaults to all risk factors.}

\item{ncol}{number of columns in output (default is 1)}

\item{labels}{show labels with the exposure (default is TRUE)}

\item{dec.mark}{control the format of the decimal point, as well as the mark
between intervals before the decimal point, choose either "," (default) or "."}

\item{ylab}{modify label for the y-axis}

\item{fill}{color to fill histogram}

\item{color}{color to plot line colors of histogram (default is "skyblue")}

\item{linetype}{use different linetypes (default is FALSE)}

\item{...}{other plotting parameters to affect the plot}
}
\value{
a ggplot2 object
}
\description{
Takes an object produced by \code{univariate()}, and plots the
available input.
}
\examples{
library(dplyr)
df <- MTPL2 \%>\%
    mutate_at(vars(area), as.factor) \%>\%
    mutate_at(vars(area), ~biggest_reference(., exposure))

mod1 <- glm(nclaims ~ area + premium, offset = log(exposure), family = poisson(), data = df)
mod2 <- glm(nclaims ~ area, offset = log(exposure), family = poisson(), data = df)

x <- rating_factors(mod1, mod2, model_data = df, exposure = exposure)
autoplot(x)

}
