% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonderivativeTransactionsPullAndScrape.R
\name{nonderivativeTransactionsPullAndScrape}
\alias{nonderivativeTransactionsPullAndScrape}
\title{nonderivativeTransactionsPullAndScrape}
\usage{
nonderivativeTransactionsPullAndScrape(
  quarter,
  year,
  form,
  name,
  email,
  transactionType = NA,
  footnoteKeywords = NA,
  issuerKeywords = NA,
  issuerTradingSymbol = NA,
  rptOwnerKeywords = NA
)
}
\arguments{
\item{quarter}{Specify the financial reporting quarter. Options are 1, 2, 3,
and 4.}

\item{year}{Specify the calendar year. Options range from 2004 to present.}

\item{form}{Specify the form type. Options are 4 or 5.}

\item{name}{Specify your name. This is required by the SEC.}

\item{email}{Specify your email. This is required by the SEC.}

\item{transactionType}{The character vector containing any specified
transaction codes. Values must be captilized to match against SEC values.
Detailed information about the transaction type can be found here:
\url{https://www.sec.gov/files/forms-3-4-5.pdf}. Default value is NA.}

\item{footnoteKeywords}{The character vector containing any specified key
words to be searched in the form's footnotes. Default is NA.}

\item{issuerKeywords}{The character vector containing any specified key
words to be searched within the issuer block. Criteria can include the firms
CIK or name. Values must be captilized to match against SEC values.
Default value is NA.}

\item{issuerTradingSymbol}{The character vector containing any specified
stock tickers.  Values must be captilized to match against SEC values.
Default value is NA.}

\item{rptOwnerKeywords}{The character vector contianing any specified key
words to be searched within the rptOwner block.  Values must be captilized
to match against SEC values. Additionally, the format is LAST NAME, FIRST
NAME. The criteria can include the individuals CIK, address, or name.
Default value is NA.}
}
\value{
A dataframe containing containing the scraped information where
each row represents a nonderivative transaction. The transaction
observations can be grouped by form through the URL variable within the
dataframe.
}
\description{
The function takes the specifieid quarter (1-4), year (2004-
2021), and form type (4 or 5) and returns a dataframe of all
the nonderivative transactions that meet the keyword crtiera from the
specified financial quarter. If no criteria is set, all transactions from
the financial quarter are scraped. Note that the logic for the
keywords is "OR." Thus if a user sets multiple footnoteKeywords and a
keyword for issuerKeywords, if a transaction has only one of the
footnoteKeywords and none of the issuerKeywords, the transaction will
still be scraped.
}
\examples{
\donttest{
dat <- nonderivativeHoldingsPullAndScrape(quarter = 1, year = 2018,
form = 4, name = "Your Name", email = "yourEmail@yourEmail.com",
rptOwnerKeywords = c("10165", "10166"))
}
}
