% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_aggregated_profiles.R
\name{plot.aggregated_profiles_explainer}
\alias{plot.aggregated_profiles_explainer}
\title{Plots Aggregated Profiles}
\usage{
\method{plot}{aggregated_profiles_explainer}(
  x,
  ...,
  size = 1,
  alpha = 1,
  color = "_label_",
  facet_ncol = NULL,
  variables = NULL,
  title = NULL,
  subtitle = NULL
)
}
\arguments{
\item{x}{a ceteris paribus explainer produced with function \code{aggregate_profiles()}}

\item{...}{other explainers that shall be plotted together}

\item{size}{a numeric. Size of lines to be plotted}

\item{alpha}{a numeric between \code{0} and \code{1}. Opacity of lines}

\item{color}{a character. Either name of a color, or hex code for a color, or \code{_label_} if models shall be colored, or \code{_ids_} if instances shall be colored}

\item{facet_ncol}{number of columns for the \code{\link[ggplot2]{facet_wrap}}}

\item{variables}{if not \code{NULL} then only \code{variables} will be presented}

\item{title}{a character. Partial and accumulated dependence explainers have deafult value.}

\item{subtitle}{a character. If \code{NULL} value will be dependent on model usage.}
}
\value{
a \code{ggplot2} object
}
\description{
Function \code{plot.aggregated_profiles_explainer} plots partial dependence plot or accumulated effect plot.
It works in a similar way to \code{plot.ceteris_paribus}, but instead of individual profiles
show average profiles for each variable listed in the \code{variables} vector.
}
\examples{
library("DALEX")

model_titanic_glm <- glm(survived ~ gender + age + fare,
                         data = titanic_imputed, family = "binomial")

explain_titanic_glm <- explain(model_titanic_glm,
                               data = titanic_imputed[,-8],
                               y = titanic_imputed[,8],
                               verbose = FALSE)

pdp_rf_p <- partial_dependence(explain_titanic_glm, N = 50)
pdp_rf_p$`_label_` <- "RF_partial"
pdp_rf_l <- conditional_dependence(explain_titanic_glm, N = 50)
pdp_rf_l$`_label_` <- "RF_local"
pdp_rf_a<- accumulated_dependence(explain_titanic_glm, N = 50)
pdp_rf_a$`_label_` <- "RF_accumulated"
head(pdp_rf_p)
plot(pdp_rf_p, pdp_rf_l, pdp_rf_a, color = "_label_")

\donttest{
library("randomForest")

model_titanic_rf <- randomForest(survived ~.,  data = titanic_imputed)

explain_titanic_rf <- explain(model_titanic_rf,
                              data = titanic_imputed[,-8],
                              y = titanic_imputed[,8],
                              label = "Random Forest v7",
                              verbose = FALSE)

selected_passangers <- select_sample(titanic_imputed, n = 100)
cp_rf <- ceteris_paribus(explain_titanic_rf, selected_passangers)
cp_rf

pdp_rf_p <- aggregate_profiles(cp_rf, variables = "age", type = "partial")
pdp_rf_p$`_label_` <- "RF_partial"
pdp_rf_c <- aggregate_profiles(cp_rf, variables = "age", type = "conditional")
pdp_rf_c$`_label_` <- "RF_conditional"
pdp_rf_a <- aggregate_profiles(cp_rf, variables = "age", type = "accumulated")
pdp_rf_a$`_label_` <- "RF_accumulated"

head(pdp_rf_p)
plot(pdp_rf_p)
plot(pdp_rf_p, pdp_rf_c, pdp_rf_a)

plot(cp_rf, variables = "age") +
  show_observations(cp_rf, variables = "age") +
  show_rugs(cp_rf, variables = "age", color = "red") +
  show_aggregated_profiles(pdp_rf_p, size = 2)

}

}
\references{
Explanatory Model Analysis. Explore, Explain and Examine Predictive Models. \url{https://pbiecek.github.io/ema}
}
