% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{visualize}
\alias{visualize}
\title{Visualize the distribution of the simulation-based inferential statistics
or the theoretical distribution (or both!)}
\usage{
visualize(data, bins = 15, method = "simulation", dens_color = "black",
  obs_stat = NULL, obs_stat_color = "#e51010", shade_color = "#efb8b8",
  direction = NULL, ...)
}
\arguments{
\item{data}{the output from \code{\link{calculate}}}

\item{bins}{the number of bins in the histogram}

\item{method}{a string giving the method to display. Options are 
"simulation", "theoretical", or "both"
with "both" corresponding to "simulation" and "theoretical"}

\item{dens_color}{a character or hex string specifying the color of the
theoretical density curve}

\item{obs_stat}{a numeric value corresponding to what the observed 
statistic is}

\item{obs_stat_color}{a character or hex string specifying the color of
the observed statistic}

\item{shade_color}{a character or hex string specifying the color to shade}

\item{direction}{a string specifying in which direction the shading 
should occur. Options are "less", "greater", or "two_sided".
Can also specify "left", "right", or "both".}

\item{...}{currently ignored}
}
\value{
A ggplot object showing the simulation-based distribution as a
 histogram or bar graph. Also used to show the theoretical curves.
}
\description{
Visualize the distribution of the simulation-based inferential statistics
or the theoretical distribution (or both!)
}
\examples{
# Permutations to create a simulation-based null distribution for 
# one numerical response and one categorical predictor
# using t statistic
mtcars \%>\%
    dplyr::mutate(am = factor(am)) \%>\%
    specify(mpg ~ am) \%>\% # alt: response = mpg, explanatory = am
    hypothesize(null = "independence") \%>\%
    generate(reps = 100, type = "permute") \%>\%
    calculate(stat = "t", order = c("1", "0")) \%>\%
    visualize(method = "simulation") #default method

# Theoretical t distribution for 
# one numerical response and one categorical predictor
# using t statistic
mtcars \%>\%
    dplyr::mutate(am = factor(am)) \%>\%
    specify(mpg ~ am) \%>\% # alt: response = mpg, explanatory = am
    hypothesize(null = "independence") \%>\%
    # generate() is not needed since we are not doing simulation
    calculate(stat = "t", order = c("1", "0")) \%>\%
    visualize(method = "theoretical")

# Overlay theoretical distribution on top of randomized t-statistics
mtcars \%>\%
    dplyr::mutate(am = factor(am)) \%>\%
    specify(mpg ~ am) \%>\% # alt: response = mpg, explanatory = am
    hypothesize(null = "independence") \%>\%
    generate(reps = 100, type = "permute") \%>\%
    calculate(stat = "t", order = c("1", "0")) \%>\%
    visualize(method = "both")
}
