% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_dim_info.R
\name{get_dim_info}
\alias{get_dim_info}
\title{Get information about the dimensions of a given indicator}
\usage{
get_dim_info(indicator, lang = "PT")
}
\arguments{
\item{indicator}{INE indicator ID as a 7 character string. Example: "0010003".}

\item{lang}{One of "PT" or "EN". Default is "PT".}
}
\value{
A data frame with dim_num (dimension number), abrv (dimension description) and versao (dimension version) for the selected indicator.
A fourth column 'nota_dsg' is present for some indicators, with additional notes about the dimensions.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} \cr
Get information about the dimensions of a given indicator
}
\details{
If the indicator is not valid, returns "(PT) O codigo do indicador nao existe. / (EN) The indicator code does not exist." \cr
Calling \code{is_indicator_valid()} before using this function is recommended.
}
\examples{
get_dim_info("0011823", lang = "EN")
}
