% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_iat.R
\name{compute_iat}
\alias{compute_iat}
\title{Compute IAT D-score}
\usage{
compute_iat(data, Dscore = c("d1", "d2", "d3", "d4", "d5", "d6"))
}
\arguments{
\item{data}{Dataframe with class \code{iat_clean}.}

\item{Dscore}{Character. Indicates which \emph{D-score} to compute. For
details on the algorithms, please refer to Greenwald
et al. (2003).}
}
\value{
Dataframe with class \code{"dscore"}. The number of rows of the
         dataframe corresponds to  the total number of participants.
         Variables are defined as follows (the values are specific for each
         participant):
 \describe{
 \item{\code{participant}}{Respondents' IDs.}
 \item{\code{n_trial}}{Number of trails before data cleaning.}
 \item{\code{nslow10000}}{Number of slow trials (> 10,000 ms).}
 \item{\code{nfast400}}{Number of fast trials (< 400 ms).}
 \item{\code{nfast300}}{Number of fast trials (< 300 ms).}
 \item{\code{accuracy.practice_MappingA}}{Proportion of correct responses
     in practice block of Mapping A.}
 \item{\code{accuracy.practice_MappingB}}{Proportion of correct responses
     in practice block of Mapping B.}
 \item{\code{accuracy.test_MappingA}}{Proportion of correct responses in test
     block of Mapping A.}
 \item{\code{accuracy.test_MappingB}}{Proportion of correct responses in test
     block of Mapping B.}
 \item{\code{accuracy.MappingA}}{Proportion of correct responses in Mapping A.}
 \item{\code{accuracy.MappingB}}{Proportion of correct responses in Mapping B.}
 \item{\code{RT_mean.MappingA}}{Mean response time in Mapping A.}
 \item{\code{RT_mean.MappingB}}{Mean response time in Mapping B.}
 \item{\code{mean_practice_MappingA}}{Mean response time in practice block of
      Mapping A.}
 \item{\code{mean_practice_MappingB}}{Mean response time in practice block of
      Mapping B.}
 \item{\code{mean_test_MappingA}}{Mean response time in test block of
      Mapping A.}
 \item{\code{mean_test_MappingB}}{Mean response time in test block of
      Mapping B.}
 \item{\code{d_practice_dX}}{\emph{D-score}s compute_iat on the practice blocks.
     The X stands for the selected \emph{D-score} procedure.}
 \item{\code{d_test_dX}}{\emph{D-score}s compute_iat on the test blocks. The X
     stands for the selected \emph{D-score} procedure.}
 \item{\code{dscore_dX}}{The average \emph{D-score} for the practice and test
    \emph{D-score}s. The X stands for the selected \emph{D-score} procedure.}
 \item{\code{cond_ord}}{Indicates the order with which the associative
     conditions have been presented, either \code{"MappingA_First"} or
    \code{"MappingB_First"}.}
 \item{\code{legendMappingA}}{Indicates the corresponding value of Mapping A
    in the original dataset.}
 \item{\code{legendMappingB}}{Indicates the corresponding value of Mapping B
    in the original dataset.}
 }
}
\description{
Compute \emph{D-score} for the IAT according to different algorithms.
}
\examples{
# compute D-score 2 for the IAT data ###
  data("raw_data") # import data
  iat_cleandata <- clean_iat(raw_data, sbj_id = "Participant",
                          block_id = "blockcode",
                          mapA_practice = "practice.iat.Milkbad",
                          mapA_test = "test.iat.Milkbad",
                          mapB_practice = "practice.iat.Milkgood",
                          mapB_test = "test.iat.Milkgood",
                          latency_id = "latency",
                          accuracy_id = "correct",
                          trial_id = "trialcode",
                          trial_eliminate = c("reminder", "reminder1"),
                          demo_id = "blockcode",
                          trial_demo = "demo")
  iat_data <- iat_cleandata[[1]]
# calculate D-score
  iat_dscore <- compute_iat(iat_data,
                         Dscore =  "d2")
}
