% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{read_tags}
\alias{read_tags}
\alias{tags_read}
\title{Read TIFF tag information without actually reading the image array.}
\usage{
read_tags(path, frames = 1)

tags_read(path, frames = 1)
}
\arguments{
\item{path}{A string. The path to the tiff file to read.}

\item{frames}{Which frames do you want to read tags from. Default first frame
only. To read from the 2nd and 7th frames, use \code{frames = c(2, 7)}, to read
from all frames, use \code{frames = "all"}.}
}
\value{
A list of lists.
}
\description{
TIFF files contain metadata about images in their \emph{TIFF tags}. This function
is for reading this information without reading the actual image.
}
\examples{
\dontrun{
read_tags(system.file("img", "Rlogo.tif", package = "ijtiff"))
read_tags(system.file("img", "2ch_ij.tif", package = "ijtiff"))
read_tags(system.file("img", "2ch_ij.tif", package = "ijtiff"),
  frames = c(2, 4)
)
}
}
\seealso{
\code{\link[=read_tif]{read_tif()}}
}
\author{
Simon Urbanek, Kent Johnson, Rory Nolan.
}
