% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/games.R
\name{sample_correlated_gnp}
\alias{sample_correlated_gnp}
\title{Generate a new random graph from a given graph by randomly
adding/removing edges}
\usage{
sample_correlated_gnp(
  old.graph,
  corr,
  p = edge_density(old.graph),
  permutation = NULL
)
}
\arguments{
\item{old.graph}{The original graph.}

\item{corr}{A scalar in the unit interval, the target Pearson
correlation between the adjacency matrices of the original and the generated
graph (the adjacency matrix being used as a vector).}

\item{p}{A numeric scalar, the probability of an edge between two
vertices, it must in the open (0,1) interval. The default is the empirical
edge density of the graph. If you are resampling an Erdős-Rényi graph and
you know the original edge probability of the Erdős-Rényi model, you should
supply that explicitly.}

\item{permutation}{A numeric vector, a permutation vector that is
applied on the vertices of the first graph, to get the second graph.  If
\code{NULL}, the vertices are not permuted.}
}
\value{
An unweighted graph of the same size as \code{old.graph} such
that the correlation coefficient between the entries of the two
adjacency matrices is \code{corr}.  Note each pair of corresponding
matrix entries is a pair of correlated Bernoulli random variables.
}
\description{
Sample a new graph by perturbing the adjacency matrix of a given graph
and shuffling its vertices.
}
\details{
Please see the reference given below.
}
\examples{
g <- sample_gnp(1000, .1)
g2 <- sample_correlated_gnp(g, corr = 0.5)
cor(as.vector(g[]), as.vector(g2[]))
g
g2
}
\references{
Lyzinski, V., Fishkind, D. E., Priebe, C. E. (2013).  Seeded
graph matching for correlated Erdős-Rényi graphs.
\url{https://arxiv.org/abs/1304.7844}
}
\seealso{
Random graph models (games)
\code{\link{erdos.renyi.game}()},
\code{\link{sample_}()},
\code{\link{sample_bipartite}()},
\code{\link{sample_correlated_gnp_pair}()},
\code{\link{sample_degseq}()},
\code{\link{sample_dot_product}()},
\code{\link{sample_fitness}()},
\code{\link{sample_fitness_pl}()},
\code{\link{sample_forestfire}()},
\code{\link{sample_gnm}()},
\code{\link{sample_gnp}()},
\code{\link{sample_grg}()},
\code{\link{sample_growing}()},
\code{\link{sample_hierarchical_sbm}()},
\code{\link{sample_islands}()},
\code{\link{sample_k_regular}()},
\code{\link{sample_last_cit}()},
\code{\link{sample_pa}()},
\code{\link{sample_pa_age}()},
\code{\link{sample_pref}()},
\code{\link{sample_sbm}()},
\code{\link{sample_smallworld}()},
\code{\link{sample_traits_callaway}()},
\code{\link{sample_tree}()}
}
\concept{games}
