% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout.R
\name{layout_on_sphere}
\alias{layout_on_sphere}
\alias{on_sphere}
\title{Graph layout with vertices on the surface of a sphere}
\usage{
layout_on_sphere(graph)

on_sphere(...)
}
\arguments{
\item{graph}{The input graph.}

\item{...}{Passed to \code{layout_on_sphere()}.}
}
\value{
A numeric matrix with three columns, and one row for each vertex.
}
\description{
Place vertices on a sphere, approximately uniformly, in the order of their
vertex ids.
}
\details{
\code{layout_on_sphere()} places the vertices (approximately) uniformly on the
surface of a sphere, this is thus a 3d layout. It is not clear however what
\dQuote{uniformly on a sphere} means.

If you want to order the vertices differently, then permute them using the
\code{\link[=permute]{permute()}} function.
}
\seealso{
Other graph layouts: 
\code{\link{add_layout_}()},
\code{\link{component_wise}()},
\code{\link{layout_}()},
\code{\link{layout_as_bipartite}()},
\code{\link{layout_as_star}()},
\code{\link{layout_as_tree}()},
\code{\link{layout_in_circle}()},
\code{\link{layout_nicely}()},
\code{\link{layout_on_grid}()},
\code{\link{layout_randomly}()},
\code{\link{layout_with_dh}()},
\code{\link{layout_with_fr}()},
\code{\link{layout_with_gem}()},
\code{\link{layout_with_graphopt}()},
\code{\link{layout_with_kk}()},
\code{\link{layout_with_lgl}()},
\code{\link{layout_with_mds}()},
\code{\link{layout_with_sugiyama}()},
\code{\link{merge_coords}()},
\code{\link{norm_coords}()},
\code{\link{normalize}()}
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\concept{graph layouts}
\keyword{graphs}
